/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBuilder
implements Cloneable {
    protected URI base;
    private final String ENC = "UTF-8";

    public URIBuilder(String url) throws URISyntaxException {
        this.base = new URI(url);
    }

    public URIBuilder(URL url) throws URISyntaxException {
        this.base = url.toURI();
    }

    public URIBuilder(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        this.base = uri;
    }

    public static URI convertToURI(Object uri) throws URISyntaxException {
        if (uri instanceof URI) {
            return (URI)uri;
        }
        if (uri instanceof URL) {
            return ((URL)uri).toURI();
        }
        if (uri instanceof URIBuilder) {
            return ((URIBuilder)uri).toURI();
        }
        return new URI(uri.toString());
    }

    protected URI update(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        URI u = new URI(scheme, userInfo, host, port, this.base.getPath(), null, null);
        StringBuilder sb = new StringBuilder();
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?').append(query);
        }
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
        return u.resolve(sb.toString());
    }

    public URIBuilder setScheme(String scheme) throws URISyntaxException {
        this.base = this.update(scheme, this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getRawPath(), this.base.getRawQuery(), this.base.getRawFragment());
        return this;
    }

    public String getScheme() {
        return this.base.getScheme();
    }

    public URIBuilder setPort(int port) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), port, this.base.getRawPath(), this.base.getRawQuery(), this.base.getRawFragment());
        return this;
    }

    public int getPort() {
        return this.base.getPort();
    }

    public URIBuilder setHost(String host) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), this.base.getUserInfo(), host, this.base.getPort(), this.base.getRawPath(), this.base.getRawQuery(), this.base.getRawFragment());
        return this;
    }

    public String getHost() {
        return this.base.getHost();
    }

    public URIBuilder setPath(String path) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), new URI(null, null, path, null, null).getRawPath(), this.base.getRawQuery(), this.base.getRawFragment());
        return this;
    }

    public String getPath() {
        return this.base.getPath();
    }

    protected URIBuilder setQueryNVP(List<NameValuePair> nvp) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        String path = this.base.getRawPath();
        if (path != null) {
            sb.append(path);
        }
        sb.append('?');
        sb.append(URLEncodedUtils.format(nvp, (String)"UTF-8"));
        String frag = this.base.getRawFragment();
        if (frag != null) {
            sb.append('#').append(frag);
        }
        this.base = this.base.resolve(sb.toString());
        return this;
    }

    public URIBuilder setQuery(Map<?, ?> params) throws URISyntaxException {
        if (params == null || params.size() < 1) {
            this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), null, this.base.getFragment());
        } else {
            ArrayList<NameValuePair> nvp = new ArrayList<NameValuePair>(params.size());
            for (Object key : params.keySet()) {
                Object value = params.get(key);
                if (value instanceof List) {
                    for (Object val : (List)value) {
                        nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), val != null ? val.toString() : ""));
                    }
                    continue;
                }
                nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), value != null ? value.toString() : ""));
            }
            this.setQueryNVP(nvp);
        }
        return this;
    }

    public URIBuilder setRawQuery(String query) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getRawPath(), query, this.base.getRawFragment());
        return this;
    }

    public Map<String, Object> getQuery() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<NameValuePair> pairs = this.getQueryNVP();
        if (pairs == null) {
            return null;
        }
        for (NameValuePair pair : pairs) {
            String key = pair.getName();
            Object existing = params.get(key);
            if (existing == null) {
                params.put(key, pair.getValue());
                continue;
            }
            if (existing instanceof List) {
                ((List)existing).add(pair.getValue());
                continue;
            }
            ArrayList<String> vals = new ArrayList<String>(2);
            vals.add((String)existing);
            vals.add(pair.getValue());
            params.put(key, vals);
        }
        return params;
    }

    protected List<NameValuePair> getQueryNVP() {
        if (this.base.getQuery() == null) {
            return null;
        }
        List nvps = URLEncodedUtils.parse((URI)this.base, (String)"UTF-8");
        ArrayList<NameValuePair> newList = new ArrayList<NameValuePair>();
        if (nvps != null) {
            newList.addAll(nvps);
        }
        return newList;
    }

    public boolean hasQueryParam(String name) {
        return this.getQuery().get(name) != null;
    }

    public URIBuilder removeQueryParam(String param) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        NameValuePair found = null;
        for (NameValuePair nvp : params) {
            if (!nvp.getName().equals(param)) continue;
            found = nvp;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("Param '" + param + "' not found");
        }
        params.remove(found);
        this.setQueryNVP(params);
        return this;
    }

    protected URIBuilder addQueryParam(NameValuePair nvp) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        if (params == null) {
            params = new ArrayList<NameValuePair>();
        }
        params.add(nvp);
        this.setQueryNVP(params);
        return this;
    }

    public URIBuilder addQueryParam(String param, Object value) throws URISyntaxException {
        this.addQueryParam((NameValuePair)new BasicNameValuePair(param, value != null ? value.toString() : ""));
        return this;
    }

    protected URIBuilder addQueryParams(List<NameValuePair> nvp) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        if (params == null) {
            params = new ArrayList<NameValuePair>();
        }
        params.addAll(nvp);
        this.setQueryNVP(params);
        return this;
    }

    public URIBuilder addQueryParams(Map<?, ?> params) throws URISyntaxException {
        ArrayList<NameValuePair> nvp = new ArrayList<NameValuePair>();
        for (Object key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), val != null ? val.toString() : ""));
                }
                continue;
            }
            nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), value != null ? value.toString() : ""));
        }
        this.addQueryParams(nvp);
        return this;
    }

    public URIBuilder setFragment(String fragment) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getRawPath(), this.base.getRawQuery(), new URI(null, null, null, fragment).getRawFragment());
        return this;
    }

    public String getFragment() {
        return this.base.getFragment();
    }

    public URIBuilder setUserInfo(String userInfo) throws URISyntaxException {
        this.base = this.update(this.base.getScheme(), userInfo, this.base.getHost(), this.base.getPort(), this.base.getRawPath(), this.base.getRawQuery(), this.base.getRawFragment());
        return this;
    }

    public String getUserInfo() {
        return this.base.getUserInfo();
    }

    public String toString() {
        return this.base.toString();
    }

    public URL toURL() throws MalformedURLException {
        return this.base.toURL();
    }

    public URI toURI() {
        return this.base;
    }

    public Object asType(Class<?> type) throws MalformedURLException {
        if (type == URI.class) {
            return this.toURI();
        }
        if (type == URL.class) {
            return this.toURL();
        }
        if (type == String.class) {
            return this.toString();
        }
        throw new ClassCastException("Cannot cast instance of URIBuilder to class " + type);
    }

    protected URIBuilder clone() {
        return new URIBuilder(this.base);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URIBuilder)) {
            return false;
        }
        return this.base.equals(((URIBuilder)obj).toURI());
    }
}

