/*
 - Licensed Materials - Property of IBM* and/or HCL**
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * Trademark of International Business Machines
 ** Trademark of HCL Technologies Limited
 */
package com.ibm.urbancode.zos.common;

import groovyx.net.http.*
import groovyx.net.http.RESTClient
import groovyx.net.http.AuthConfig
import groovyx.net.http.ContentType

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class PublishedSoftwareServiceTemplate extends zOSMFRESTService{

    def templateName;
    def inputProperties;
    def domainName;
    def tenantName;
    def userDataId;
    def userData;
    def accountInfo;
    def systemsNicknames;

    def PublishedSoftwareServiceTemplate(baseURL, username, password, untrustedSSL,useCertifactes,clientCertificatePath,certPassword){
        super(baseURL, username, password, untrustedSSL,useCertifactes,clientCertificatePath,certPassword);
    }

    def run(templateName){
        try{
            def body =  [:]
            //add optional fields
            if(domainName)              body << ["domain-name" : domainName]
            if(tenantName)              body << ["tenant-name" : tenantName]
            if(userDataId)              body << ["user-data-id" : userDataId]
            if(userData)                body << ["user-data" : userData]
            if(accountInfo)             body << ["account-info" : accountInfo]
            if(systemsNicknames)        body << ["systems-nicknames" : systemsNicknames.split()]
            if(inputProperties){
                def vJSON = []
                def vProp =new Properties()
                vProp.load(new StringReader(inputProperties))
                vProp.each{key,value->
                    println "-- ${key}, ${value}"
                    vJSON.add(["name":key,"value":value])
                }
                println vJSON.toString();
                //body << ["input-properties" : vJSON]
                //Although z/OSMF doc says input-properties, the correct names seems to be input-variables
                body << ["input-variables" : vJSON]
            }
            def path = "/zosmf/provisioning/rest/${CURRENT_VERSION}/psc/${templateName}/actions/run"
            printRequest(path,body);
            client.headers['X-CSRF-ZOSMF-HEADER']="UCD";
            def resp  = client.post(
                    path : path,
                    body : body,
                    requestContentType: ContentType.JSON
                    )
            if(processRespose(resp) && resp.data){
                return resp.data;
            }else{
                return [:];
            }
        }catch (HttpResponseException e){
            processResponseException(e);
            return null;
        }
    }

    def boolean processSpecificRespose(resp){
    }
}

