/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.ibm.urbancode.zos.common;

import groovy.json.JsonSlurper
import groovyx.net.http.*


public class zOSMFInformation extends zOSMFRESTService{
    
    def zOSMFInformation(baseURL, username, password, untrustedSSL){
        super(baseURL, username, password, untrustedSSL);
    }
    
    def getInformation(){
        try{
            def path = "/zosmf/info"
            def resp  = client.get(  path : path,
                             query : [:],
                             requestContentType: ContentType.JSON
                          )
            printRequest(path,null);
            if(processRespose(resp) && resp.data){
                //This service returns Content-Type: text/plain
                def jsonSlurper = new JsonSlurper()
                def info = jsonSlurper.parseText(resp.data.text)
                
                return info;
            }else{
                return null;
            }
        }catch (HttpResponseException e){
            processResponseException(e);
            return null;
        }
    }

    def boolean processSpecificRespose(resp){
        
    }
}

