/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.ibm.urbancode.zos.common;

import groovyx.net.http.*
import groovyx.net.http.RESTClient
import groovyx.net.http.AuthConfig
import groovyx.net.http.ContentType

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class SoftwareServiceInstance extends zOSMFRESTService{
    
    def SoftwareServiceInstance(baseURL, username, password, untrustedSSL){
        super(baseURL, username, password, untrustedSSL);
    }
    
    def getSoftwareServicesInstance(objectId){
        try{
            def path = "/zosmf/provisioning/rest/${CURRENT_VERSION}/scr/${objectId}"
            def resp  = client.get(  path : path,
                             query : [:],
                             requestContentType: ContentType.JSON
                          )
            printRequest(path,null);
            if(processRespose(resp) && resp.data){
                return resp.data;
            }else{
                return null;
            }
        }catch (HttpResponseException e){
            processResponseException(e);
            return null;
        }
    }
    
    def getVariables(objectId){
        try{
            def path = "/zosmf/provisioning/rest/${CURRENT_VERSION}/scr/${objectId}/variables" 
            def resp  = client.get(  path : path,
                             query : [:],
                             requestContentType: ContentType.JSON
                          )
            printRequest(path,null);
            if(processRespose(resp) && resp.data){
                return resp.data;
            }else{
                return null;
            }
        }catch (HttpResponseException e){
            processResponseException(e);
            return null;
        }
    }
    
    def listSoftwareServicesInstances(q){
        def qmap = [:];
        if(q && (q.trim().length()>0)){
            def vProp =new Properties()
            vProp.load(new StringReader(q))
            vProp.each{key,value->
                println "Adding query parameter ${key}, ${value}"
                qmap[key]=value;
            }
        }
        
        try{
            def path = "/zosmf/provisioning/rest/${CURRENT_VERSION}/scr"
            def resp  = client.get(  path : path,
                             query : qmap,
                             requestContentType: ContentType.JSON
                          )
            printRequest(path,null);
            if(processRespose(resp) && resp.data){
                return resp.data;
            }else{
                return null;
            }
        }catch (HttpResponseException e){
            processResponseException(e);
            return null;
        }
    }
 
    def boolean processSpecificRespose(resp){
    }
}

