/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2017 - 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import org.codehaus.jettison.json.JSONArray
import org.codehaus.jettison.json.JSONObject

import com.ibm.urbancode.zos.common.zOSMFInformation
import com.urbancode.air.AirPluginTool

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def rootResourcePath = props['resourcePath'];
def zOSMFURL = props['zOSMFURL'];
def sysUser = props['sysUser'];
def roleName = "zOSMFService";

def addResourcePath = { JSONArray resourcePathJsonArr, String url, String resourcePath ->
    // If a resource was created, add it to the array of resource paths
    if (resourcePath != null && !resourcePath.isEmpty()) {
        if (url == null) {
            url = "";
        }
        JSONObject resourcePair = new JSONObject();
        resourcePair.put("zosmf.url", url);
        resourcePair.put("resourcePath", resourcePath);
        
        resourcePathJsonArr.put(resourcePair);
    }
}

def tmpResourcePath = "";
JSONArray resourcePathArr = new JSONArray();

if (zOSMFURL != null && zOSMFURL != ""){
    println "Found z/OSMF service at " + zOSMFURL;
	apTool.setOutputProperty("roleName", roleName);
    apTool.setOutputProperty("zosmf.url", zOSMFURL);
    apTool.setOutputProperty("zosmf.user", sysUser);
    apTool.setOutputProperty("zosmf.password", "");
    
    try{
        def zOSMFInformation = new zOSMFInformation(zOSMFURL, "","",true);
        def info = zOSMFInformation.getInformation();
        if(info){
            apTool.setOutputProperty("zosmf.zosmf_hostname", info.zosmf_hostname)
            apTool.setOutputProperty("zosmf.zosmf_port", info.zosmf_port)
            apTool.setOutputProperty("zosmf.zosmf_version", info.zosmf_version)
            apTool.setOutputProperty("zosmf.zos_version", info.zos_version)
            apTool.setOutputProperty("zosmf.api_version", info.api_version)
            apTool.setOutputProperty("zosmf.zosmf_saf_realm", info.zosmf_saf_realm)
            apTool.setOutputProperty("zosmf.zosmf_full_version", info.zosmf_full_version)
            println "z/OSMF service information retrived"
        }
    }catch(e){
        println "Warning: failed o retrive z/OSMF service information. "
        e.printStackTrace();
    }
    
    tmpResourcePath = rootResourcePath + "/" + roleName;
    addResourcePath(resourcePathArr, zOSMFURL, tmpResourcePath); // add it to the array of resource paths
}
else {
	println "z/OSMF Service Not Found. Ending discovery process.";
}
apTool.setOutputProperty("createdResources", resourcePathArr.toString());
apTool.setOutputProperties();
