/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.util.PlanApiClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.Properties;

public class DeletePlanRecord {
    private static final String PROP_BASE_URL = "baseUrl";
    private static final String PROP_API_TOKEN = "apiToken";
    private static final String PROP_TEAMSPACE_ID = "teamspaceId";
    private static final String PROP_APPLICATION_NAME = "applicationName";
    private static final String PROP_RECORD_TYPE = "recordType";
    private static final String PROP_ITEM_NAME = "itemName";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public DeletePlanRecord(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String baseUrl = this.inputProperties.getProperty(PROP_BASE_URL);
            String apiToken = this.inputProperties.getProperty(PROP_API_TOKEN);
            String teamspaceId = this.inputProperties.getProperty(PROP_TEAMSPACE_ID);
            String applicationName = this.encode(this.inputProperties.getProperty(PROP_APPLICATION_NAME));
            String recordType = this.encode(this.inputProperties.getProperty(PROP_RECORD_TYPE));
            String itemName = this.encode(this.inputProperties.getProperty(PROP_ITEM_NAME));
            Boolean trustAllCerts = Boolean.parseBoolean(this.inputProperties.getProperty("trustAllCerts", "false"));
            if (baseUrl == null || baseUrl.isEmpty()) {
                throw new IllegalArgumentException("Base URL is missing.");
            }
            if (apiToken == null || apiToken.isEmpty()) {
                throw new IllegalArgumentException("API Token is missing.");
            }
            if (teamspaceId == null || teamspaceId.isEmpty()) {
                throw new IllegalArgumentException("Teamspace ID is missing.");
            }
            PlanApiClient apiClient = new PlanApiClient(baseUrl, apiToken, trustAllCerts);
            System.out.println("Attempting to resolve DBID for: " + recordType + "/" + itemName);
            String dbId = apiClient.resolveDbId(teamspaceId, applicationName, recordType, itemName);
            if (dbId == null || dbId.isEmpty()) {
                throw new IllegalArgumentException("Could not find DBID for Item: " + itemName);
            }
            System.out.println("Targeting Record DBID: " + dbId);
            apiClient.deleteRecord(teamspaceId, applicationName, recordType, dbId);
            System.out.println("Successfully deleted " + recordType + " (DBID: " + dbId + ")");
            return 0;
        }
        catch (Exception e) {
            System.err.println("Deletion execution failed: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java DeletePlanRecord <input.props> <output.props>");
            System.exit(1);
        }
        Properties inputProps = new Properties();
        Properties outputProps = new Properties();
        try {
            DeletePlanRecord.loadProperties(args[0], inputProps);
            DeletePlanRecord step = new DeletePlanRecord(inputProps, outputProps);
            int exitCode = step.execute();
            if (exitCode == 0) {
                DeletePlanRecord.saveProperties(args[1], outputProps);
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("Initialization failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void loadProperties(String path, Properties props) throws Exception {
        try (FileInputStream input = new FileInputStream(path);){
            props.load(input);
        }
    }

    private static void saveProperties(String path, Properties props) throws Exception {
        try (FileOutputStream output = new FileOutputStream(path);){
            props.store(output, "UCD Output Properties");
        }
    }

    private String encode(String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value to encode cannot be null or empty");
        }
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encode value: " + value, e);
        }
    }
}

