/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.util.PlanApiClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CreatePlanItem {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public CreatePlanItem(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String baseUrl = this.inputProperties.getProperty("baseUrl");
            String apiToken = this.inputProperties.getProperty("apiToken");
            String teamspaceId = this.inputProperties.getProperty("teamspaceId");
            String applicationName = this.encode("applicationName", this.inputProperties.getProperty("applicationName"));
            String itemType = this.encode("itemType", this.inputProperties.getProperty("itemType"));
            String additionalFieldsJson = this.inputProperties.getProperty("additionalFieldsJson");
            Boolean trustAllCerts = Boolean.parseBoolean(this.inputProperties.getProperty("trustAllCerts", "false"));
            if (baseUrl == null || baseUrl.isEmpty()) {
                throw new IllegalArgumentException("Base URL is missing.");
            }
            if (apiToken == null || apiToken.isEmpty()) {
                throw new IllegalArgumentException("API Token is missing.");
            }
            if (teamspaceId == null || teamspaceId.isEmpty()) {
                throw new IllegalArgumentException("Teamspace ID is missing.");
            }
            PlanApiClient apiClient = new PlanApiClient(baseUrl, apiToken, trustAllCerts);
            boolean isValidItemType = false;
            isValidItemType = apiClient.getValidItemType(applicationName, teamspaceId).contains(itemType);
            if (!isValidItemType) {
                throw new IllegalArgumentException("Item type is invalid. Please Enter a valid Item Type.");
            }
            JSONObject payload = CreatePlanItem.buildJsonPayload(additionalFieldsJson);
            System.out.println("Constructed JSON Payload: " + payload.toString(2));
            String apiUrl = String.format("/repos/%s/databases/%s/records/%s?operation=Commit", teamspaceId, applicationName, itemType);
            JSONObject response = apiClient.executePostRequest(apiUrl, payload);
            String dbId = response.optString("dbId", null);
            String displayName = response.optString("displayName", null);
            if (dbId == null || dbId.isEmpty()) {
                throw new Exception("API response missing 'dbId'. Full response: " + response);
            }
            System.out.printf("Successfully created new Plan Item (Type: %s) with name: %s%n", itemType, displayName);
            this.outputProperties.setProperty(itemType.toLowerCase() + ".dbId", dbId);
            this.outputProperties.setProperty("displayName", displayName);
            System.out.println("Output Property Set: " + itemType.toLowerCase() + ".dbId = " + dbId);
            System.out.println("Output Property Set: " + displayName + " " + displayName);
            return 0;
        }
        catch (Exception e) {
            System.err.println("Plugin execution failed: " + e.getMessage());
            return 1;
        }
    }

    private String encode(String propertyName, String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value to encode for property '" + propertyName + "' cannot be null or empty");
        }
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encode value for property '" + propertyName + "': " + value, e);
        }
    }

    private static JSONObject buildJsonPayload(String dynamicFieldsJson) throws JSONException {
        JSONArray fieldsArray = new JSONArray();
        if (dynamicFieldsJson != null && !dynamicFieldsJson.trim().isEmpty() && !"{}".equals(dynamicFieldsJson.trim())) {
            try {
                JSONObject dynamicFields = new JSONObject(dynamicFieldsJson);
                Iterator it = dynamicFields.keys();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String value = dynamicFields.optString(name);
                    if (value == null || value.isEmpty()) continue;
                    fieldsArray.put((Object)new JSONObject().put("name", (Object)name).put("value", (Object)value));
                }
            }
            catch (JSONException e) {
                System.out.println("Warning: Dynamic Fields JSON is malformed. Skipping. Error: " + e.getMessage());
            }
        }
        return new JSONObject().put("fields", (Object)fieldsArray);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java CreatePlanItem <input.props> <output.props>");
            System.exit(1);
        }
        Properties inputProps = new Properties();
        Properties outputProps = new Properties();
        try {
            CreatePlanItem.loadProperties(args[0], inputProps);
            CreatePlanItem step = new CreatePlanItem(inputProps, outputProps);
            int exitCode = step.execute();
            if (exitCode == 0) {
                CreatePlanItem.saveProperties(args[1], outputProps);
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("Initialization failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void loadProperties(String path, Properties props) throws Exception {
        try (FileInputStream input = new FileInputStream(path);){
            props.load(input);
        }
    }

    private static void saveProperties(String path, Properties props) throws Exception {
        try (FileOutputStream output = new FileOutputStream(path);){
            for (String key : props.stringPropertyNames()) {
                ((OutputStream)output).write((key + "=" + props.getProperty(key) + "\n").getBytes());
            }
        }
    }
}

