/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.util.PlanApiClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class UpdatePlanRecord {
    private static final String PROP_BASE_URL = "baseUrl";
    private static final String PROP_API_TOKEN = "apiToken";
    private static final String PROP_TEAMSPACE_ID = "teamspaceId";
    private static final String PROP_APPLICATION_NAME = "applicationName";
    private static final String PROP_RECORD_TYPE = "recordType";
    private static final String PROP_RECORD_NAME = "recordName";
    private static final String PROP_ADDITIONAL_FIELDS_JSON = "fieldsToUpdateJson";
    private static final String PROP_TRUST_CERTIFICATE = "trustAllCerts";
    private static final String[] EXPLICIT_FIELDS = new String[]{"Name", "Description", "StartDate", "EndDate", "Delivered", "Frozen", "Title", "State", "Resolution", "Tags", "Component", "Parent", "Project", "Owner", "WIType", "Severity", "Priority", "StoryPoints", "PlannedRelease", "Sprint"};
    private final Properties inputProperties;
    private final Properties outputProperties;

    public UpdatePlanRecord(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    private static JSONObject buildUpdatePayload(String dbId, Properties props) throws JSONException {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        String rawJson = props.getProperty(PROP_ADDITIONAL_FIELDS_JSON);
        if (rawJson != null && !rawJson.trim().isEmpty() && !"{}".equals(rawJson.trim())) {
            try {
                JSONObject dynamicJson = new JSONObject(rawJson);
                Iterator keys = dynamicJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    fieldsMap.put(key, dynamicJson.optString(key));
                }
            }
            catch (JSONException e) {
                System.err.println("Warning: 'Additional Fields' JSON is malformed. Skipping JSON block. Error: " + e.getMessage());
            }
        }
        for (String field : EXPLICIT_FIELDS) {
            String val = props.getProperty(field);
            if (val == null || val.trim().isEmpty()) continue;
            fieldsMap.put(field, val);
        }
        JSONObject root = new JSONObject();
        root.put("dbId", (Object)dbId);
        JSONArray fieldsArray = new JSONArray();
        for (Map.Entry entry : fieldsMap.entrySet()) {
            JSONObject fieldObj = new JSONObject();
            fieldObj.put("name", entry.getKey());
            fieldObj.put("value", entry.getValue());
            fieldsArray.put((Object)fieldObj);
        }
        root.put("fields", (Object)fieldsArray);
        return root;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java UpdatePlanItem <input.props> <output.props>");
            System.exit(1);
        }
        Properties inputProps = new Properties();
        Properties outputProps = new Properties();
        try {
            UpdatePlanRecord.loadProperties(args[0], inputProps);
            UpdatePlanRecord step = new UpdatePlanRecord(inputProps, outputProps);
            int exitCode = step.execute();
            if (exitCode == 0) {
                UpdatePlanRecord.saveProperties(args[1], outputProps);
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("Initialization failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void loadProperties(String path, Properties props) throws Exception {
        try (FileInputStream input = new FileInputStream(path);){
            props.load(input);
        }
    }

    private static void saveProperties(String path, Properties props) throws Exception {
        try (FileOutputStream output = new FileOutputStream(path);){
            for (String key : props.stringPropertyNames()) {
                ((OutputStream)output).write((key + "=" + props.getProperty(key) + "\n").getBytes());
            }
        }
    }

    public int execute() {
        try {
            String baseUrl = this.inputProperties.getProperty(PROP_BASE_URL);
            String apiToken = this.inputProperties.getProperty(PROP_API_TOKEN);
            String teamspaceId = this.inputProperties.getProperty(PROP_TEAMSPACE_ID);
            String applicationName = this.encode(PROP_APPLICATION_NAME, this.inputProperties.getProperty(PROP_APPLICATION_NAME));
            String recordName = this.encode(PROP_RECORD_NAME, this.inputProperties.getProperty(PROP_RECORD_NAME));
            String recordType = this.encode(PROP_RECORD_TYPE, this.inputProperties.getProperty(PROP_RECORD_TYPE));
            Boolean trustAllCerts = Boolean.parseBoolean(this.inputProperties.getProperty(PROP_TRUST_CERTIFICATE, "false"));
            if (baseUrl == null || baseUrl.isEmpty()) {
                throw new IllegalArgumentException("Base URL is missing.");
            }
            if (apiToken == null || apiToken.isEmpty()) {
                throw new IllegalArgumentException("API Token is missing.");
            }
            if (teamspaceId == null || teamspaceId.isEmpty()) {
                throw new IllegalArgumentException("Teamspace ID is missing.");
            }
            PlanApiClient apiClient = new PlanApiClient(baseUrl, apiToken, trustAllCerts);
            String dbId = apiClient.resolveDbId(teamspaceId, applicationName, recordType, recordName);
            if (dbId == null || dbId.isEmpty()) {
                throw new IllegalArgumentException("Could not find DB ID for Item: " + recordName);
            }
            System.out.println("Record DBID: " + dbId);
            JSONObject payload = UpdatePlanRecord.buildUpdatePayload(dbId, this.inputProperties);
            if (!payload.has("fields") || payload.getJSONArray("fields").length() == 0) {
                System.out.println("No fields provided to update. Skipping API call.");
                return 0;
            }
            System.out.println("Constructed Update Payload: " + payload.toString(2));
            String apiUrl = String.format("/repos/%s/databases/%s/records/%s/%s?operation=Commit&useDbid=true", teamspaceId, applicationName, recordType, dbId);
            JSONObject response = apiClient.executePatchRequest(apiUrl, payload);
            String displayName = response.optString("displayName", null);
            System.out.printf("Successfully updated %s (DBID: %s)%n", recordType, dbId);
            this.outputProperties.setProperty(recordType.toLowerCase() + ".dbId", dbId);
            this.outputProperties.setProperty("displayName", displayName);
            return 0;
        }
        catch (Exception e) {
            System.err.println("Update execution failed: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private String encode(String propertyName, String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value to encode for property '" + propertyName + "' cannot be null or empty");
        }
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encode value for property '" + propertyName + "': " + value, e);
        }
    }
}

