/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class PlanApiClient {
    private final String baseUrl;
    private final String authHeaderValue;
    private final boolean trustAllCerts;
    public static final String DEFAULT_API_PATH = "/ccmweb/rest";

    public PlanApiClient(String baseUrl, String apiToken, Boolean trustAllCerts) {
        this.baseUrl = baseUrl;
        this.authHeaderValue = "Basic " + apiToken;
        this.trustAllCerts = trustAllCerts;
        System.out.println("PlanApiClient initialized: trustAllCerts=" + trustAllCerts);
    }

    private CloseableHttpClient createHttpClient() {
        if (!this.trustAllCerts) {
            return HttpClients.createDefault();
        }
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            System.out.println("Using INSECURE HttpClient - SSL validation DISABLED");
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslFactory).build();
        }
        catch (Exception e) {
            System.err.println("Failed to create trust-all SSL client. Falling back to secure client.");
            return HttpClients.createDefault();
        }
    }

    /*
     * Exception decompiling
     */
    public JSONObject executePostRequest(String apiUrl, JSONObject payload) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getValidItemType(String applicationName, String teamspaceId) throws Exception {
        ArrayList<String> validItemTypes = new ArrayList<String>();
        String apiUrl = String.format("/repos/%s/databases/%s", teamspaceId, applicationName);
        try (CloseableHttpClient httpClient = this.createHttpClient();){
            String normalizedBaseUrl = this.baseUrl.endsWith("/") ? this.baseUrl.substring(0, this.baseUrl.length() - 1) : this.baseUrl;
            String fullUrl = normalizedBaseUrl + DEFAULT_API_PATH + apiUrl;
            System.out.println("Executing GET Request: " + fullUrl);
            HttpGet httpGet = new HttpGet(fullUrl);
            httpGet.setHeader("Authorization", this.authHeaderValue);
            httpGet.setHeader("Content-Type", "application/json");
            httpGet.setHeader("Accept", "application/json");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                String responseBody = Optional.ofNullable(response.getEntity()).map(e -> {
                    try {
                        return EntityUtils.toString((HttpEntity)e, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (Exception ex) {
                        System.err.println("Error reading response body: " + ex.getMessage());
                        return "{}";
                    }
                }).orElse("{}");
                JSONObject jsonResponse = new JSONObject(responseBody);
                JSONArray entityDefNames = jsonResponse.optJSONArray("entityDefNames");
                if (entityDefNames != null) {
                    for (int i = 0; i < entityDefNames.length(); ++i) {
                        validItemTypes.add(entityDefNames.getString(i));
                    }
                }
            }
        }
        return validItemTypes;
    }

    public String resolveDbId(String teamspaceId, String applicationName, String recordType, String recordName) throws Exception {
        String apiUrlFragment = String.format("/repos/%s/databases/%s/records/%s/%s", teamspaceId, applicationName, recordType, recordName);
        System.out.println("Fetching record details via GET...");
        JSONObject response = this.executeGetRequest(apiUrlFragment);
        String dbId = response.optString("dbId", null);
        if (dbId == null || dbId.isEmpty()) {
            throw new Exception("GET response missing 'dbId'. Record lookup failed for " + recordName);
        }
        return dbId;
    }

    public JSONObject executeGetRequest(String apiUrlFragment) throws Exception {
        String normalizedBaseUrl = this.baseUrl.endsWith("/") ? this.baseUrl.substring(0, this.baseUrl.length() - 1) : this.baseUrl;
        String fullUrl = normalizedBaseUrl + DEFAULT_API_PATH + apiUrlFragment;
        Throwable throwable = null;
        try (CloseableHttpClient client = this.createHttpClient();){
            String respBody;
            int status;
            Throwable throwable2;
            CloseableHttpResponse response;
            block25: {
                JSONObject jSONObject;
                block26: {
                    block27: {
                        HttpGet get = new HttpGet(fullUrl);
                        get.setHeader("Accept", "application/json");
                        get.setHeader("Authorization", this.authHeaderValue);
                        response = client.execute((HttpUriRequest)get);
                        throwable2 = null;
                        status = response.getStatusLine().getStatusCode();
                        respBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (status < 200 || status >= 300) break block25;
                        jSONObject = new JSONObject(respBody);
                        if (response == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    response.close();
                }
                return jSONObject;
            }
            try {
                try {
                    try {
                        throw new Exception("GET failed. Status: " + status + ". URL: " + fullUrl + ". Response: " + respBody);
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public JSONObject executePatchRequest(String apiUrlFragment, JSONObject payload) throws Exception {
        String normalizedBaseUrl = this.baseUrl.endsWith("/") ? this.baseUrl.substring(0, this.baseUrl.length() - 1) : this.baseUrl;
        String fullUrl = normalizedBaseUrl + DEFAULT_API_PATH + apiUrlFragment;
        Throwable throwable = null;
        try (CloseableHttpClient client = this.createHttpClient();){
            String respBody;
            int status;
            Throwable throwable2;
            CloseableHttpResponse response;
            block32: {
                block33: {
                    JSONObject jSONObject;
                    block34: {
                        block35: {
                            HttpPatch patch = new HttpPatch(fullUrl);
                            patch.setHeader("Content-Type", "application/json");
                            patch.setHeader("Accept", "application/json");
                            patch.setHeader("Authorization", this.authHeaderValue);
                            patch.setEntity((HttpEntity)new StringEntity(payload.toString(), StandardCharsets.UTF_8));
                            response = client.execute((HttpUriRequest)patch);
                            throwable2 = null;
                            status = response.getStatusLine().getStatusCode();
                            respBody = EntityUtils.toString((HttpEntity)response.getEntity());
                            if (status < 200 || status >= 300) break block32;
                            if (!respBody.trim().isEmpty()) break block33;
                            jSONObject = new JSONObject().put("status", (Object)"success");
                            if (response == null) break block34;
                            if (throwable2 == null) break block35;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block34;
                        }
                        response.close();
                    }
                    return jSONObject;
                }
                JSONObject jSONObject = new JSONObject(respBody);
                return jSONObject;
            }
            try {
                try {
                    throw new Exception("PATCH failed. Status: " + status + ". URL: " + fullUrl + ". Response: " + respBody);
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (response != null) {
                    if (throwable2 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void executeDeleteRequest(String apiUrlFragment) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteRecord(String teamspaceId, String applicationName, String recordType, String dbId) throws Exception {
        String apiUrlFragment = String.format("/repos/%s/databases/%s/records/%s/%s?actionName=Delete&useDbid=true", teamspaceId, applicationName, recordType, dbId);
        this.executeDeleteRequest(apiUrlFragment);
    }

    private static /* synthetic */ String lambda$executePostRequest$1(HttpEntity e) {
        try {
            return EntityUtils.toString((HttpEntity)e, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            System.err.println("Error reading response body: " + ex.getMessage());
            return "{}";
        }
    }
}

