/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientWithPropertySheet;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Change;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.internal.IntegrationProvider;

public class Initiative
extends ClientWithPropertySheet<Initiative> {
    public IntegrationProvider<?> integrationProvider;
    @JsonReadOnly
    public Change[] changes;
    @JsonReadOnly
    public Release[] releases;
    @JsonReadOnly
    public Application[] applications;

    public Initiative() {
        this.path = "/initiatives/";
    }

    public IntegrationProvider<?> getIntegrationProvider() {
        return this.integrationProvider;
    }

    public Initiative setIntegrationProvider(IntegrationProvider<?> integrationProvider) {
        return this.integrationProvider(integrationProvider);
    }

    public Initiative integrationProvider(IntegrationProvider<?> integrationProvider) {
        this.handleNull(integrationProvider, "integrationProvider");
        this.integrationProvider = integrationProvider;
        return this;
    }

    public Change[] getChanges() {
        return this.changes;
    }

    public Release[] getReleases() {
        return this.releases;
    }

    public Application[] getApplications() {
        return this.applications;
    }

    public Response updateChanges(Change ... changes) {
        for (Change change : changes) {
            change.initiative(this);
        }
        return new Change.ChangesUpdate().changes(changes).type(Change.ChangeAssociation.INITIATIVE).id(this.id).send();
    }

    @Deprecated
    public Initiative[] getAllForIntegrationProvider(String integrationProviderId) {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "allForProvider/" + integrationProviderId, new Object[0])).as(Initiative[].class, ObjectMapperType.GSON);
    }

    @Deprecated
    public void deleteAllForIntegrationProvider(String integrationProviderId) {
        this.query.apply(RestAssured.given()).when().delete(this.path() + "allForProvider/" + integrationProviderId, new Object[0]);
    }
}

