/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.scripting;

import com.urbancode.commons.scripting.ScriptException;
import com.urbancode.commons.scripting.ScriptSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;

public class ScriptSourceImplFile
implements ScriptSource {
    private static final long serialVersionUID = 198848292569018105L;
    private String path = null;
    private String content = null;
    private transient File scriptFile = null;

    public ScriptSourceImplFile(String path) {
        this.path = path;
    }

    public ScriptSourceImplFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getScriptPath() {
        String result = this.path;
        if (result == null && this.scriptFile != null) {
            result = this.scriptFile.getAbsolutePath();
        }
        return result;
    }

    public File getScriptFile() {
        File result = this.scriptFile;
        if (this.scriptFile == null && this.path != null) {
            result = new File(this.path);
        }
        return result;
    }

    public String getScriptContent() throws ScriptException {
        if (this.content == null) {
            try {
                this.loadScriptContent();
            }
            catch (IOException e) {
                throw new ScriptException(e);
            }
        }
        return this.content;
    }

    protected void loadScriptContent() throws IOException {
        StringBuffer result = new StringBuffer();
        Reader in = null;
        File file = this.getScriptFile();
        try {
            char[] buf = new char[256];
            in = new FileReader(file);
            int read = 0;
            while ((read = in.read(buf)) > 0) {
                result.append(buf, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("script file not found [" + file + "]");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.content = result.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.content == null) {
            this.loadScriptContent();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

