/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email.spooler;

import com.urbancode.air.notification.email.spooler.EmailSpoolManager;
import com.urbancode.air.notification.email.spooler.RestoredError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoredEmail {
    private static Logger logger = Logger.getLogger(RestoredEmail.class);
    private final File spooledEmailDir;
    private final File messageFile;
    private final boolean ready;
    private final boolean failed;
    private final RestoredError error;
    private final MimeMessage message;

    public RestoredEmail(File spooledEmailDir) throws IOException, MessagingException {
        this.spooledEmailDir = spooledEmailDir;
        this.messageFile = new File(spooledEmailDir, "message");
        Properties props = System.getProperties();
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        FileInputStream source = new FileInputStream(this.messageFile);
        this.message = new MimeMessage(mailSession, (InputStream)source);
        ((InputStream)source).close();
        this.ready = new File(spooledEmailDir, "_ready").exists();
        this.failed = new File(spooledEmailDir, "_error").exists();
        if (this.failed) {
            List<String> lines = this.readFileAsStringList(new File(spooledEmailDir, "_error"));
            Date failureDate = new Date(Long.parseLong(lines.get(0)));
            String stackTrace = "";
            for (int i = 1; i < lines.size(); ++i) {
                stackTrace = stackTrace + lines.get(i) + "\n";
            }
            this.error = new RestoredError(failureDate, stackTrace);
        } else {
            this.error = null;
        }
    }

    private List<String> readFileAsStringList(File file) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            result.add(line);
        }
        reader.close();
        return result;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public File getMessageFile() {
        return this.messageFile;
    }

    public Address[] getToAddressArray() throws MessagingException {
        return this.message.getAllRecipients();
    }

    public String getSubject() throws MessagingException {
        return this.message.getSubject();
    }

    public RestoredError getError() {
        return this.error;
    }

    public File getDir() {
        return this.spooledEmailDir;
    }

    public void reSend(EmailSpoolManager manager) {
        this.spooledEmailDir.renameTo(new File(manager.getWorkingDir().getAbsolutePath() + "/" + this.spooledEmailDir.getName()));
    }

    public void delete() {
        for (File file : this.spooledEmailDir.listFiles()) {
            if (file.delete()) continue;
            logger.warn((Object)("Unable to delete temporary file '" + file.getPath() + "'."));
        }
        if (!this.spooledEmailDir.delete()) {
            logger.warn((Object)("Unable to delete spooled email dir '" + this.spooledEmailDir.getPath() + "'."));
        }
    }
}

