/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email.spooler;

import com.urbancode.air.notification.DefaultEmailLock;
import com.urbancode.air.notification.EmailLock;
import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.spooler.EmailSpoolManager;
import com.urbancode.air.notification.email.spooler.Emailer;
import com.urbancode.air.notification.email.spooler.Error;
import com.urbancode.air.notification.email.spooler.ErrorHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpooledEmailCollector
implements Runnable {
    private static Logger logger = Logger.getLogger(SpooledEmailCollector.class);
    private EmailSpoolManager spoolManager = null;
    private final long pause = 10000L;
    private Thread thread = null;
    private boolean running = true;
    private boolean sleeping = false;
    private File workingDir = null;
    private ExecutorService executor;
    private int maxSendingThreads = 0;
    private File readyFile = null;
    private ErrorHandler errorHandler = new ErrorHandler();
    private EmailLock emailLock = null;

    SpooledEmailCollector(EmailSpoolManager spoolManager) {
        this.spoolManager = spoolManager;
        this.thread = new Thread((Runnable)this, "Spooled email collector");
        this.workingDir = spoolManager.getWorkingDir();
        this.maxSendingThreads = spoolManager.getMaxSendingThreads();
        this.executor = Executors.newFixedThreadPool(this.maxSendingThreads);
        this.emailLock = DefaultEmailLock.getInstance();
        logger.debug((Object)"Configured");
    }

    SpooledEmailCollector(EmailSpoolManager spoolManager, EmailLock emailLock) {
        this(spoolManager);
        this.emailLock = emailLock;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.sleeping = false;
                List<File> tempDirList = this.retriveReadySpooledMails();
                if (!tempDirList.isEmpty()) {
                    File[] sortedDirList = this.sortFilesAscendingByDate(tempDirList);
                    logger.debug((Object)("Found " + tempDirList.size() + " email(s) to send"));
                    CountDownLatch latch = new CountDownLatch(sortedDirList.length);
                    for (File dir : sortedDirList) {
                        try {
                            logger.debug((Object)"Sending email dispatched");
                            Emailer emailer = new Emailer(this.spoolManager.getEmailService(), latch, dir, this.errorHandler, this.emailLock);
                            this.executor.execute(emailer);
                        }
                        catch (NotificationException e) {
                            throw new RuntimeException("Mail has not been sent: " + e.getMessage(), e);
                        }
                    }
                    logger.debug((Object)"Waiting for all emails sent");
                    latch.await();
                    this.processErrors(this.errorHandler);
                }
                logger.debug((Object)"No email to send - sleeping for 10 s...");
                this.sleeping = true;
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.shutdown();
            }
            catch (Exception e) {
                logger.error((Object)"Error in email collector", (Throwable)e);
                try {
                    this.sleeping = true;
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e2) {
                    this.shutdown();
                }
            }
        }
        if (logger != null) {
            logger.info((Object)"Finished");
        }
    }

    private void processErrors(ErrorHandler errorHandler) {
        List<Error> errors = errorHandler.getErrors();
        if (!errors.isEmpty()) {
            logger.info((Object)("Sending errors: " + errors.size()));
            String failedEmailDir = this.spoolManager.getFailedEmailDir().getAbsolutePath();
            for (Error error : errors) {
                File failedEmail = error.getSpooledEmailDir();
                try {
                    File errorFile = new File(failedEmail.getAbsolutePath() + "/" + "_error");
                    errorFile.createNewFile();
                    Throwable throwable = error.getError();
                    PrintStream printStream = new PrintStream(errorFile);
                    printStream.println(error.getFailureDate().getTime());
                    throwable.printStackTrace(printStream);
                    printStream.close();
                    failedEmail.renameTo(new File(failedEmailDir + "/" + failedEmail.getName()));
                }
                catch (IOException e) {}
            }
            logger.info((Object)("Failed emails moved to " + failedEmailDir));
        } else {
            logger.info((Object)"All emails sent successfully");
        }
        errorHandler.reset();
    }

    protected boolean isAlive() {
        return this.thread.isAlive();
    }

    private File[] sortFilesAscendingByDate(List<File> filesToSort) {
        File[] files = filesToSort.toArray(new File[0]);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (((File)o1).lastModified() < ((File)o2).lastModified()) {
                    return -1;
                }
                if (((File)o1).lastModified() > ((File)o2).lastModified()) {
                    return 1;
                }
                return 0;
            }
        });
        return files;
    }

    private List<File> retriveReadySpooledMails() {
        File[] allChildDirs;
        ArrayList<File> tempDirList = new ArrayList<File>();
        FileFilter dirFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        for (File dir : allChildDirs = this.workingDir.listFiles(dirFilter)) {
            this.readyFile = new File(dir, "_ready");
            if (!this.readyFile.exists()) continue;
            tempDirList.add(dir);
        }
        return tempDirList;
    }

    public void start() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread((Runnable)this, "Spooled email collector");
            this.thread.start();
            logger.info((Object)"Started");
        }
    }

    public void stop() {
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            logger.info((Object)"Stopped");
        }
    }

    public void shutdown() {
        logger.info((Object)"Shutting down...");
        this.running = false;
        if (this.sleeping) {
            this.stop();
        } else {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        logger.info((Object)"Shutting thread pool down...");
        this.executor.shutdown();
        if (!this.executor.isTerminated()) {
            int shutdownWait = 60;
            long start = System.currentTimeMillis();
            logger.info((Object)("Thread pool still active - awaiting shutdown for " + shutdownWait + " s..."));
            try {
                this.executor.awaitTermination(shutdownWait, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Stopping thread pool", (Throwable)e);
                logger.info((Object)"Forcing thread pool shutdown");
                this.executor.shutdownNow();
            }
            long stop = System.currentTimeMillis();
            long time = (stop - start) / 1000L;
            logger.info((Object)("Thread pool terminated after " + time + " s"));
        } else {
            logger.info((Object)"Thread pool terminated immediately");
        }
    }
}

