/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.template;

import com.urbancode.air.notification.template.MultiSectionTemplate;
import com.urbancode.air.notification.template.Template;
import com.urbancode.air.notification.template.TemplateLoader;
import com.urbancode.commons.scripting.ScriptEvaluator;
import com.urbancode.commons.scripting.ScriptMetaData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateApplication {
    private static final Logger log = Logger.getLogger((String)TemplateApplication.class.getName());
    private static final long serialVersionUID = 6118702830445590016L;
    private Template template;
    private String encoding;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();

    public TemplateApplication(Template template) {
        this(template, "UTF-8");
    }

    public TemplateApplication(Template template, String encoding) {
        this.template = template.getContentType() != null ? template : new MultiSectionTemplate(template).getTemplateSection();
        this.encoding = encoding;
    }

    public InputStream getStream() throws IOException {
        PipedInputStream result = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(result);
        Thread velocityThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TemplateApplication.this.writeTo(out);
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        });
        velocityThread.start();
        return result;
    }

    public String getString() throws IOException {
        StringWriter writer = new StringWriter();
        try {
            this.writeTemplateApplication(writer);
        }
        catch (Exception e) {
            IOException ioe = new IOException("error writing templated content");
            ioe.initCause(e);
            throw ioe;
        }
        return writer.toString();
    }

    public void writeTo(OutputStream out) throws IOException {
        try {
            OutputStreamWriter writer = this.getEncoding() != null ? new OutputStreamWriter(out, this.getEncoding()) : new OutputStreamWriter(out);
            this.writeTemplateApplication(writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            IOException ioe = new IOException("error writing templated content");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public String getContentType() {
        return this.getTemplate().getContentType();
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void writeTemplateApplication(Writer writer) throws Exception {
        TemplateLoader loader;
        VelocityEngine velocity = new VelocityEngine();
        velocity.addProperty("runtime.introspector.uberspect", (Object)"org.apache.velocity.tools.generic.introspection.PublicFieldUberspect");
        velocity.setProperty("velocimacro.library", (Object)"");
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.AvalonLogChute");
        velocity.setProperty("runtime.log.logsystem.log4j.category", (Object)TemplateApplication.class.getName());
        velocity.setProperty("resource.loader", (Object)"file");
        velocity.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        velocity.setProperty("file.resource.loader.cache", (Object)"true");
        Template template = this.getTemplate();
        if (template != null && (loader = template.getTemplateLoader()) != null) {
            File templateDir = loader.getTemplateDir();
            String path = "";
            if (templateDir != null) {
                path = templateDir.toString() + "/";
            }
            velocity.setProperty("file.resource.loader.path", (Object)path);
        }
        velocity.init();
        VelocityContext context = new VelocityContext();
        for (String propName : this.getPropertyNameArray()) {
            context.put(propName, this.getProperty(propName));
        }
        ScriptMetaData contextScript = this.getTemplate().getContextScript();
        if (contextScript != null) {
            try {
                HashMap<String, VelocityContext> params = new HashMap<String, VelocityContext>();
                params.put("context", context);
                ScriptEvaluator.evaluate((ScriptMetaData)contextScript, params, null, null);
            }
            catch (Exception e) {
                log.error((Object)("Error executing script: " + e.getMessage()), (Throwable)e);
                log.debug((Object)("Script contents: " + contextScript));
            }
        }
        velocity.evaluate((Context)context, writer, "", this.getTemplate().getTemplateText());
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.propertyMap.put(name, value);
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.propertyMap.get(name);
    }

    public Object removeProperty(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.propertyMap.remove(name);
    }

    public String[] getPropertyNameArray() {
        Set<String> keySet = this.propertyMap.keySet();
        String[] result = new String[keySet.size()];
        keySet.toArray(result);
        return result;
    }
}

