/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.framework;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.framework.QueryParams;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public abstract class ClientEntity<T extends ClientEntity>
implements Cloneable {
    protected static Logger log = Logger.getLogger(ClientEntity.class);
    protected transient String path;
    protected transient String oldPath;
    public String id;
    @JsonReadOnly
    public Long dateCreated;
    public transient QueryParams<T> query = new QueryParams(this);
    public transient Set<String> nulls = new HashSet<String>();

    public static String[] ids(List<? extends ClientEntity> entities) {
        String[] ids = new String[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            ids[i] = entities.get((int)i).id;
        }
        return ids;
    }

    public static String[] ids(ClientEntity<?> ... entities) {
        String[] ids = new String[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            ids[i] = entities[i].id;
        }
        return ids;
    }

    public QueryParams newQuery() {
        this.query = new QueryParams(this);
        return this.query;
    }

    public QueryParams newQuery(QueryParams other) {
        this.query = new QueryParams(this, other);
        return this.query;
    }

    public QueryParams<T> format(String format) {
        return this.query.format(format);
    }

    public QueryParams<T> nameFormat() {
        return this.query.nameFormat();
    }

    public QueryParams<T> listFormat() {
        return this.query.listFormat();
    }

    public QueryParams<T> detailFormat() {
        return this.query.detailFormat();
    }

    public QueryParams<T> orderBy(String orderField) {
        return this.query.orderBy(orderField);
    }

    public QueryParams<T> orderBy(String orderField, boolean asc) {
        return this.query.orderBy(orderField, asc);
    }

    public QueryParams<T> param(String name, String ... values) {
        return this.query.param(name, values);
    }

    public QueryParams<T> filter(String field, QueryParams.FilterClass filterClass, QueryFilter.FilterType type, Object ... values) {
        return this.query.filter(field, filterClass, type, values);
    }

    public QueryParams<T> like(String field, String like) {
        return this.query.like(field, like);
    }

    public QueryParams<T> equals(String field, QueryParams.FilterClass filterClass, String match) {
        return this.query.equals(field, filterClass, match);
    }

    public String path() {
        log.debug("path()");
        return this.path;
    }

    public String path(String id) {
        log.debug("path(id)");
        return this.path + id;
    }

    @Deprecated
    protected String oldPath() {
        log.debug("oldPath()");
        return this.oldPath;
    }

    @Deprecated
    protected String oldPath(String id) {
        log.debug("oldPath(id)");
        return this.oldPath + id;
    }

    public String getId() {
        return this.id;
    }

    public T setId(String id) {
        return this.id(id);
    }

    public T id(String id) {
        this.id = id;
        return (T)this;
    }

    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Deprecated
    public Response getAllResponse() {
        log.debug("getAllResponse()");
        return (Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path(), new Object[0]);
    }

    public T[] getAll() {
        log.debug("getAll()");
        return (ClientEntity[])this.getAllResponse().as(this.arrayClass(), ObjectMapperType.GSON);
    }

    public T[] getPage(int start, int end) {
        log.debug("getAll()");
        return (ClientEntity[])((Response)this.query.apply(RestAssured.given()).header("Range", "items=" + start + '-' + end, new Object[0]).expect().contentType(ContentType.JSON).when().get(this.path(), new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
    }

    @Deprecated
    public Response getResponse() {
        log.debug("getResponse()");
        return (Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path(this.id), new Object[0]);
    }

    public T get() {
        log.debug("get()");
        return (T)((ClientEntity)this.getResponse().as(this.modelClass(), ObjectMapperType.GSON));
    }

    public T post() {
        log.debug("post()");
        this.id = ((Response)this.query.apply(RestAssured.given()).body((Object)this, ObjectMapperType.GSON).expect().statusCode(201).post(this.path(), new Object[0])).then().extract().header("Location");
        log.debug("getting post() response Location");
        this.id = this.id.substring(this.id.lastIndexOf(47) + 1);
        log.debug("retrieved post() response ID:" + this.id);
        return (T)this;
    }

    public T[] post(T ... toCreate) {
        return this.post(Arrays.asList(toCreate));
    }

    public T[] post(List<T> toCreate) {
        log.debug("post(many)");
        ClientEntity[] response = (ClientEntity[])((Response)this.query.apply(RestAssured.given()).body(toCreate, ObjectMapperType.GSON).expect().statusCode(201).when().post(this.path(), new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        for (int i = 0; i < toCreate.size(); ++i) {
            ((ClientEntity)toCreate.get((int)i)).id = response[i].id;
        }
        return response;
    }

    @Deprecated
    public T[] post(File csvFile) {
        log.debug("post(CSV)");
        ClientEntity[] response = (ClientEntity[])((Response)this.query.apply(RestAssured.given()).multiPart(csvFile).contentType("multipart/form-data").expect().statusCode(201).when().post(this.path(), new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        return response;
    }

    public Response put() {
        log.debug("put()");
        return (Response)this.query.apply(RestAssured.given()).body((Object)this, ObjectMapperType.GSON).put(this.path(this.id), new Object[0]);
    }

    public Response put(T ... toUpdate) {
        return this.put(Arrays.asList(toUpdate));
    }

    public Response put(List<T> toUpdate) {
        log.debug("put(many)");
        return (Response)this.query.apply(RestAssured.given()).body(toUpdate, ObjectMapperType.GSON).put(this.path(), new Object[0]);
    }

    public T save() {
        log.debug("save()");
        if (this.id == null) {
            this.post();
        } else {
            this.put();
        }
        return this.get();
    }

    public Response delete() {
        log.debug("delete()");
        return (Response)this.query.apply(RestAssured.given()).delete(this.path(this.id), new Object[0]);
    }

    public Response delete(T ... toDelete) {
        return this.delete(Arrays.asList(toDelete));
    }

    public Response delete(List<T> toDelete) {
        return (Response)this.query.apply(RestAssured.given()).body((Object)ClientEntity.ids(toDelete), ObjectMapperType.GSON).delete(this.path(), new Object[0]);
    }

    public Response delete(String ... toDelete) {
        return (Response)this.query.apply(RestAssured.given()).body((Object)toDelete, ObjectMapperType.GSON).delete(this.path(), new Object[0]);
    }

    public T findItem(T ... entities) {
        List<T> list = Arrays.asList(entities);
        int i = list.indexOf(this);
        if (i >= 0) {
            return (T)((ClientEntity)list.get(i));
        }
        return null;
    }

    protected Class<T> modelClass() {
        return this.getClass();
    }

    protected Class<T[]> arrayClass() {
        return Array.newInstance(this.modelClass(), 0).getClass();
    }

    protected boolean handleNull(Object value, String ... properties) {
        if (value == null) {
            this.nulls.addAll(Arrays.asList(properties));
            return false;
        }
        this.nulls.removeAll(Arrays.asList(properties));
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientEntity) {
            ClientEntity other = (ClientEntity)obj;
            if (this == other) {
                return true;
            }
            if (this.id == null || other.id == null) {
                return false;
            }
            return other.id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public T clone() {
        try {
            return ((ClientEntity)super.clone()).id(null);
        }
        catch (CloneNotSupportedException e) {
            RuntimeException re = new RuntimeException("This should be impossible....", e);
            log.error(re);
            throw re;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

