/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.twitter;

import com.urbancode.air.notification.twitter.TwitterService;
import java.util.ArrayList;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterSender
implements Runnable {
    private static final String STATUS_URL = "http://api.twitter.com/1/statuses/update.xml";
    private String body = null;
    private ArrayList<String> accountNameList = null;
    private Token accessToken = null;

    TwitterSender(String body, ArrayList<String> accountName) {
        this.body = body.trim();
        this.accountNameList = accountName;
    }

    @Override
    public void run() {
        System.out.println("Body: " + this.body);
        for (String name : this.accountNameList) {
            this.accessToken = this.getAccessToken(name);
            if (this.body == null || this.accessToken == null) {
                System.out.println("Invalid body or account");
                continue;
            }
            OAuthRequest request = new OAuthRequest(Verb.POST, STATUS_URL);
            request.addBodyParameter("status", this.body);
            OAuthService service = TwitterService.getService();
            service.signRequest(this.accessToken, request);
            try {
                Response response = request.send();
                if (response.getCode() >= 200 && response.getCode() >= 300) continue;
            }
            catch (Exception e) {
                System.out.println("Twitter status update failed: " + e.getMessage());
            }
        }
    }

    private Token getAccessToken(String accountName) {
        return new Token("269889069-SYEN4GDU7n2GgJ4Bbtw1fg4NztuBgzX8ozrS05Pv", "KVpoaqyrCuLpBbNDfU02iWV8VqW5hV8WQQDca1Isayk");
    }
}

