/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuth10aServiceImpl
implements OAuthService {
    private static final String NO_SCOPE = null;
    private static final String VERSION = "1.0";
    private OAuthConfig config;
    private DefaultApi10a api;
    private String scope;

    public OAuth10aServiceImpl(DefaultApi10a api, OAuthConfig config) {
        this.api = api;
        this.config = config;
        this.scope = NO_SCOPE;
    }

    @Override
    public Token getRequestToken() {
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        this.addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        this.addOAuthHeader(request);
        Response response = request.send();
        return this.api.getRequestTokenExtractor().extract(response.getBody());
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        request.addOAuthParameter("oauth_callback", this.config.getCallback());
        if (this.scope != NO_SCOPE) {
            request.addOAuthParameter("scope", this.scope);
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", verifier.getValue());
        this.addOAuthParams(request, requestToken);
        this.addOAuthHeader(request);
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    public void signRequest(Token token, OAuthRequest request) {
        request.addOAuthParameter("oauth_token", token.getToken());
        this.addOAuthParams(request, token);
        this.addOAuthHeader(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void addScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, Token token) {
        String baseString = this.api.getBaseStringExtractor().extract(request);
        return this.api.getSignatureService().getSignature(baseString, this.config.getApiSecret(), token.getSecret());
    }

    private void addOAuthHeader(OAuthRequest request) {
        String oauthHeader = this.api.getHeaderExtractor().extract(request);
        request.addHeader("Authorization", oauthHeader);
    }
}

