/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.email.Attachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmailMessage {
    protected Map<String, Object> context = null;
    private List<String> toList = new ArrayList<String>();
    private List<String> ccList = new ArrayList<String>();
    private List<String> bccList = new ArrayList<String>();
    private List<Attachment> attachmentList = new ArrayList<Attachment>();

    public EmailMessage(Map<String, Object> context, List<String> toList, List<String> ccList, List<String> bccList, List<Attachment> attachmentList) {
        this.context = context;
        this.toList = toList;
        this.ccList = ccList;
        this.bccList = bccList;
        this.attachmentList = attachmentList;
    }

    public EmailMessage(Map<String, Object> context) {
        this.context = context;
    }

    public void addToRecipient(String recipient) {
        if (recipient != null) {
            this.toList.add(recipient);
        }
    }

    public void addCcRecipient(String recipient) {
        if (recipient != null) {
            this.ccList.add(recipient);
        }
    }

    public void addBccRecipient(String recipient) {
        if (recipient != null) {
            this.bccList.add(recipient);
        }
    }

    public void addAttachment(Attachment attachment) {
        this.attachmentList.add(attachment);
    }

    private String compressWhitespace(String s) {
        String token;
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(s);
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            result.append(token);
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            result.append(' ');
            result.append(token);
        }
        return result.toString();
    }

    public List<String> getToList() {
        return this.toList;
    }

    public List<String> getCcList() {
        return this.ccList;
    }

    public List<String> getBccList() {
        return this.bccList;
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    protected Map<String, Object> getContext() {
        return this.context;
    }
}

