/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email.spooler;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.Attachment;
import com.urbancode.air.notification.email.EmailSender;
import com.urbancode.air.notification.email.TemplatedEmailMessage;
import com.urbancode.air.notification.email.WrappedFileDataSource;
import com.urbancode.air.notification.email.spooler.EmailSpoolManager;
import com.urbancode.air.notification.template.TemplateApplication;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class SpoolingTemplatedEmailSender
extends EmailSender {
    private static Logger logger = Logger.getLogger(SpoolingTemplatedEmailSender.class);
    private static final long serialVersionUID = -1929772359027636377L;
    private EmailSpoolManager spoolManager = null;

    public SpoolingTemplatedEmailSender(EmailSpoolManager spoolManager) {
        super(spoolManager.getEmailService());
        this.spoolManager = spoolManager;
    }

    /*
     * Loose catch block
     */
    public void send(TemplatedEmailMessage email) throws NotificationException {
        block31: {
            Exception e22;
            WrappedFileDataSource bodySource;
            FileOutputStream fos;
            File tempFile;
            block29: {
                StringBuilder msg = this.buildRecipientLogMessage(email);
                logger.debug((Object)msg.toString());
                if (email.getToList().size() + email.getCcList().size() + email.getBccList().size() == 0) {
                    throw new NotificationException("No email addresses found for recipients");
                }
                tempFile = null;
                fos = null;
                bodySource = null;
                UUID dirSuffix = UUID.randomUUID();
                File currentSpooledMailDir = new File(this.spoolManager.getWorkingDir(), "mail-" + dirSuffix);
                currentSpooledMailDir.mkdir();
                TemplateApplication subject = email.getSubject();
                String subjectLine = subject.getString();
                subjectLine = this.compressWhitespace(subjectLine).trim();
                InternetAddress[] toAddressArray = this.getInternetAddresses(email.getToList());
                InternetAddress[] ccAddressArray = this.getInternetAddresses(email.getCcList());
                InternetAddress[] bccAddressArray = this.getInternetAddresses(email.getBccList());
                TemplateApplication body = email.getBody();
                tempFile = new File(currentSpooledMailDir + "/body.temp");
                fos = new FileOutputStream(tempFile);
                body.writeTo(fos);
                fos.close();
                fos = null;
                bodySource = new WrappedFileDataSource(tempFile, body.getContentType(), body.getEncoding());
                DataHandler bodyHandler = new DataHandler((DataSource)bodySource);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(bodyHandler);
                ContentType contentType = new ContentType(bodySource.getContentType());
                bodyPart.setHeader("Content-Type", contentType.toString());
                String[] propNameArray = body.getPropertyNameArray();
                HashMap<String, String> headerProperties = new HashMap<String, String>();
                for (int i = 0; i < propNameArray.length; ++i) {
                    if (!propNameArray[i].trim().toUpperCase().startsWith("X-")) continue;
                    headerProperties.put(propNameArray[i], body.getProperty(propNameArray[i]).toString());
                }
                String primaryType = contentType.getPrimaryType();
                String encoding = contentType.getParameter("charset");
                String contentTransferEncoding = "text".equals(primaryType) && "US-ASCII".equalsIgnoreCase(encoding) ? "7bit" : "base64";
                bodyPart.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
                ArrayList<MimeBodyPart> attachmentList = new ArrayList<MimeBodyPart>();
                for (Attachment attachment : email.getAttachmentList()) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    DataSource source = attachment.createDataSource();
                    messageBodyPart.setDataHandler(new DataHandler(source));
                    if (attachment.getContentType() != null) {
                        messageBodyPart.setHeader("Content-Type", attachment.getContentType());
                    }
                    if (attachment.getContentTransferEncoding() != null) {
                        messageBodyPart.setHeader("Content-Transfer-Encoding", attachment.getContentTransferEncoding());
                    }
                    messageBodyPart.setFileName(attachment.getFileName());
                    if (attachment.getDisposition() != null) {
                        messageBodyPart.setDisposition(attachment.getDisposition());
                    } else {
                        messageBodyPart.setDisposition("attachment");
                    }
                    if (attachment.getContentId() != null) {
                        messageBodyPart.setContentID(attachment.getContentId());
                    }
                    attachmentList.add(messageBodyPart);
                }
                MimeBodyPart[] attachmentPartArray = new MimeBodyPart[attachmentList.size()];
                attachmentList.toArray(attachmentPartArray);
                MimeMessage message = new MimeMessage(Session.getInstance((Properties)new Properties()));
                if (toAddressArray != null) {
                    logger.debug((Object)("sendEmail() to: " + Arrays.asList(toAddressArray)));
                    message.addRecipients(Message.RecipientType.TO, (Address[])toAddressArray);
                }
                if (ccAddressArray != null) {
                    logger.debug((Object)("sendEmail() cc: " + Arrays.asList(ccAddressArray)));
                    message.addRecipients(Message.RecipientType.CC, (Address[])ccAddressArray);
                }
                if (bccAddressArray != null) {
                    logger.debug((Object)("sendEmail() bcc: " + Arrays.asList(bccAddressArray)));
                    message.addRecipients(Message.RecipientType.BCC, (Address[])bccAddressArray);
                }
                message.setSubject(subjectLine, "UTF-8");
                message.setHeader("X-Mailer", "Anthill3");
                message.setSentDate(new Date());
                Set entrySet = headerProperties.entrySet();
                for (Map.Entry entry : entrySet) {
                    String propName = (String)entry.getKey();
                    String propValue = (String)entry.getValue();
                    message.setHeader(propName, propValue);
                }
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)bodyPart);
                for (MimeBodyPart attachment : attachmentList) {
                    multipart.addBodyPart((BodyPart)attachment);
                }
                message.setContent((Multipart)multipart);
                File messageTempFile = new File(currentSpooledMailDir, "message");
                fos = new FileOutputStream(messageTempFile);
                message.writeTo((OutputStream)fos);
                fos.close();
                fos = null;
                File readyTempFile = new File(currentSpooledMailDir, "_ready");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(readyTempFile));
                bufferedWriter.write("_ready");
                bufferedWriter.flush();
                bufferedWriter.close();
                Object var32_34 = null;
                if (fos == null) break block29;
                try {
                    fos.close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (bodySource != null) {
                try {
                    bodySource.getInputStream().close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
            }
            break block31;
            {
                catch (IOException e3) {
                    throw new NotificationException(e3);
                }
                catch (Exception e4) {
                    logger.warn((Object)("Unable to send email: " + e4.getMessage()), (Throwable)e4);
                    throw new NotificationException(e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var32_35 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (bodySource != null) {
                    try {
                        bodySource.getInputStream().close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                    logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
                }
                throw throwable;
            }
        }
    }
}

