/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.scripting;

import com.urbancode.commons.scripting.ScriptLanguage;
import com.urbancode.commons.scripting.ScriptMetaData;
import org.apache.log4j.Logger;

public class InlineScriptHelper {
    private static final Logger log = Logger.getLogger((String)InlineScriptHelper.class.getName());
    private static InlineScriptHelper instance = new InlineScriptHelper();

    public static InlineScriptHelper getInstance() {
        return instance;
    }

    private InlineScriptHelper() {
    }

    protected ScriptMetaData createScriptMetaData(String string) {
        ScriptMetaData result = null;
        if (string != null) {
            if (string.startsWith("${bsh:") && string.endsWith("}")) {
                String script = this.stripBrackets(string).replace("\\}", "}");
                result = new ScriptMetaData(null, null, ScriptLanguage.BEANSHELL, script);
            } else if (string.startsWith("${gvy:") && string.endsWith("}")) {
                String script = this.stripBrackets(string).replace("\\}", "}");
                result = new ScriptMetaData(null, null, ScriptLanguage.GROOVY, script);
            } else {
                log.debug((Object)("Did not evaluate script because the script was not in ${bsh:<script>} format.  Script: " + string));
            }
        }
        return result;
    }

    protected String stripBrackets(String var) {
        return var.substring(6, var.length() - 1);
    }
}

