/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeUnit;
import com.ibm.icu.util.UResourceBundle;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureUnit
implements Serializable {
    private static final long serialVersionUID = -1839973855554750484L;
    private static final String[] unitKeys = new String[]{"units", "unitsShort", "unitsNarrow"};
    private static final Map<String, Map<String, MeasureUnit>> cache = new HashMap<String, Map<String, MeasureUnit>>();
    @Deprecated
    protected final String type;
    @Deprecated
    protected final String subType;
    static final UnicodeSet ASCII = new UnicodeSet(97, 122).freeze();
    static final UnicodeSet ASCII_HYPHEN = new UnicodeSet(45, 45, 97, 122).freeze();
    private static Factory UNIT_FACTORY = new Factory(){

        public MeasureUnit create(String type, String subType) {
            return new MeasureUnit(type, subType);
        }
    };
    static Factory CURRENCY_FACTORY = new Factory(){

        public MeasureUnit create(String unusedType, String subType) {
            return new Currency(subType);
        }
    };
    static Factory TIMEUNIT_FACTORY = new Factory(){

        public MeasureUnit create(String type, String subType) {
            return new TimeUnit(type, subType);
        }
    };
    public static final MeasureUnit G_FORCE;
    public static final MeasureUnit DEGREE;
    public static final MeasureUnit ARC_MINUTE;
    public static final MeasureUnit ARC_SECOND;
    public static final MeasureUnit ACRE;
    public static final MeasureUnit HECTARE;
    public static final MeasureUnit SQUARE_FOOT;
    public static final MeasureUnit SQUARE_KILOMETER;
    public static final MeasureUnit SQUARE_METER;
    public static final MeasureUnit SQUARE_MILE;
    public static final MeasureUnit MILLISECOND;
    public static final MeasureUnit CENTIMETER;
    public static final MeasureUnit FOOT;
    public static final MeasureUnit INCH;
    public static final MeasureUnit KILOMETER;
    public static final MeasureUnit LIGHT_YEAR;
    public static final MeasureUnit METER;
    public static final MeasureUnit MILE;
    public static final MeasureUnit MILLIMETER;
    public static final MeasureUnit PICOMETER;
    public static final MeasureUnit YARD;
    public static final MeasureUnit GRAM;
    public static final MeasureUnit KILOGRAM;
    public static final MeasureUnit OUNCE;
    public static final MeasureUnit POUND;
    public static final MeasureUnit HORSEPOWER;
    public static final MeasureUnit KILOWATT;
    public static final MeasureUnit WATT;
    public static final MeasureUnit HECTOPASCAL;
    public static final MeasureUnit INCH_HG;
    public static final MeasureUnit MILLIBAR;
    public static final MeasureUnit KILOMETER_PER_HOUR;
    public static final MeasureUnit METER_PER_SECOND;
    public static final MeasureUnit MILE_PER_HOUR;
    public static final MeasureUnit CELSIUS;
    public static final MeasureUnit FAHRENHEIT;
    public static final MeasureUnit CUBIC_KILOMETER;
    public static final MeasureUnit CUBIC_MILE;
    public static final MeasureUnit LITER;
    public static TimeUnit YEAR;
    public static TimeUnit MONTH;
    public static TimeUnit WEEK;
    public static TimeUnit DAY;
    public static TimeUnit HOUR;
    public static TimeUnit MINUTE;
    public static TimeUnit SECOND;

    @Deprecated
    protected MeasureUnit(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subType;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.subType.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof MeasureUnit)) {
            return false;
        }
        MeasureUnit c = (MeasureUnit)rhs;
        return this.type.equals(c.type) && this.subType.equals(c.subType);
    }

    public String toString() {
        return this.type + "-" + this.subType;
    }

    public static synchronized Set<String> getAvailableTypes() {
        return Collections.unmodifiableSet(cache.keySet());
    }

    public static synchronized Set<MeasureUnit> getAvailable(String type) {
        Map<String, MeasureUnit> units = cache.get(type);
        return units == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<MeasureUnit>(units.values()));
    }

    public static synchronized Set<MeasureUnit> getAvailable() {
        HashSet<MeasureUnit> result = new HashSet<MeasureUnit>();
        for (String type : new HashSet<String>(MeasureUnit.getAvailableTypes())) {
            for (MeasureUnit unit : MeasureUnit.getAvailable(type)) {
                result.add(unit);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Deprecated
    public static MeasureUnit internalGetInstance(String type, String subType) {
        if (type == null || subType == null) {
            throw new NullPointerException("Type and subType must be non-null");
        }
        if (!("currency".equals(type) || ASCII.containsAll(type) && ASCII_HYPHEN.containsAll(subType))) {
            throw new IllegalArgumentException("The type or subType are invalid.");
        }
        Factory factory = "currency".equals(type) ? CURRENCY_FACTORY : ("duration".equals(type) ? TIMEUNIT_FACTORY : UNIT_FACTORY);
        return MeasureUnit.addUnit(type, subType, factory);
    }

    @Deprecated
    protected static synchronized MeasureUnit addUnit(String type, String unitName, Factory factory) {
        Map<String, MeasureUnit> tmp = cache.get(type);
        if (tmp == null) {
            tmp = new HashMap<String, MeasureUnit>();
            cache.put(type, tmp);
        } else {
            type = tmp.entrySet().iterator().next().getValue().type;
        }
        MeasureUnit unit = tmp.get(unitName);
        if (unit == null) {
            unit = factory.create(type, unitName);
            tmp.put(unitName, unit);
        }
        return unit;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MeasureUnitProxy(this.type, this.subType);
    }

    static {
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b", "en");
        for (String key : unitKeys) {
            try {
                ICUResourceBundle unitsTypeRes = resource.getWithFallback(key);
                int size = unitsTypeRes.getSize();
                for (int index = 0; index < size; ++index) {
                    UResourceBundle unitsRes = unitsTypeRes.get(index);
                    String type = unitsRes.getKey();
                    int unitsSize = unitsRes.getSize();
                    for (int index2 = 0; index2 < unitsSize; ++index2) {
                        ICUResourceBundle unitNameRes = (ICUResourceBundle)unitsRes.get(index2);
                        if (unitNameRes.get("other") == null) continue;
                        MeasureUnit.internalGetInstance(type, unitNameRes.getKey());
                    }
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b", "currencyNumericCodes", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle codeMap = bundle.get("codeMap");
            Enumeration<String> it = codeMap.getKeys();
            while (it.hasMoreElements()) {
                MeasureUnit.internalGetInstance("currency", it.nextElement());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        G_FORCE = MeasureUnit.internalGetInstance("acceleration", "g-force");
        DEGREE = MeasureUnit.internalGetInstance("angle", "degree");
        ARC_MINUTE = MeasureUnit.internalGetInstance("angle", "arc-minute");
        ARC_SECOND = MeasureUnit.internalGetInstance("angle", "arc-second");
        ACRE = MeasureUnit.internalGetInstance("area", "acre");
        HECTARE = MeasureUnit.internalGetInstance("area", "hectare");
        SQUARE_FOOT = MeasureUnit.internalGetInstance("area", "square-foot");
        SQUARE_KILOMETER = MeasureUnit.internalGetInstance("area", "square-kilometer");
        SQUARE_METER = MeasureUnit.internalGetInstance("area", "square-meter");
        SQUARE_MILE = MeasureUnit.internalGetInstance("area", "square-mile");
        MILLISECOND = MeasureUnit.internalGetInstance("duration", "millisecond");
        CENTIMETER = MeasureUnit.internalGetInstance("length", "centimeter");
        FOOT = MeasureUnit.internalGetInstance("length", "foot");
        INCH = MeasureUnit.internalGetInstance("length", "inch");
        KILOMETER = MeasureUnit.internalGetInstance("length", "kilometer");
        LIGHT_YEAR = MeasureUnit.internalGetInstance("length", "light-year");
        METER = MeasureUnit.internalGetInstance("length", "meter");
        MILE = MeasureUnit.internalGetInstance("length", "mile");
        MILLIMETER = MeasureUnit.internalGetInstance("length", "millimeter");
        PICOMETER = MeasureUnit.internalGetInstance("length", "picometer");
        YARD = MeasureUnit.internalGetInstance("length", "yard");
        GRAM = MeasureUnit.internalGetInstance("mass", "gram");
        KILOGRAM = MeasureUnit.internalGetInstance("mass", "kilogram");
        OUNCE = MeasureUnit.internalGetInstance("mass", "ounce");
        POUND = MeasureUnit.internalGetInstance("mass", "pound");
        HORSEPOWER = MeasureUnit.internalGetInstance("power", "horsepower");
        KILOWATT = MeasureUnit.internalGetInstance("power", "kilowatt");
        WATT = MeasureUnit.internalGetInstance("power", "watt");
        HECTOPASCAL = MeasureUnit.internalGetInstance("pressure", "hectopascal");
        INCH_HG = MeasureUnit.internalGetInstance("pressure", "inch-hg");
        MILLIBAR = MeasureUnit.internalGetInstance("pressure", "millibar");
        KILOMETER_PER_HOUR = MeasureUnit.internalGetInstance("speed", "kilometer-per-hour");
        METER_PER_SECOND = MeasureUnit.internalGetInstance("speed", "meter-per-second");
        MILE_PER_HOUR = MeasureUnit.internalGetInstance("speed", "mile-per-hour");
        CELSIUS = MeasureUnit.internalGetInstance("temperature", "celsius");
        FAHRENHEIT = MeasureUnit.internalGetInstance("temperature", "fahrenheit");
        CUBIC_KILOMETER = MeasureUnit.internalGetInstance("volume", "cubic-kilometer");
        CUBIC_MILE = MeasureUnit.internalGetInstance("volume", "cubic-mile");
        LITER = MeasureUnit.internalGetInstance("volume", "liter");
        YEAR = (TimeUnit)MeasureUnit.internalGetInstance("duration", "year");
        MONTH = (TimeUnit)MeasureUnit.internalGetInstance("duration", "month");
        WEEK = (TimeUnit)MeasureUnit.internalGetInstance("duration", "week");
        DAY = (TimeUnit)MeasureUnit.internalGetInstance("duration", "day");
        HOUR = (TimeUnit)MeasureUnit.internalGetInstance("duration", "hour");
        MINUTE = (TimeUnit)MeasureUnit.internalGetInstance("duration", "minute");
        SECOND = (TimeUnit)MeasureUnit.internalGetInstance("duration", "second");
    }

    static final class MeasureUnitProxy
    implements Externalizable {
        private static final long serialVersionUID = -3910681415330989598L;
        private String type;
        private String subType;

        public MeasureUnitProxy(String type, String subType) {
            this.type = type;
            this.subType = subType;
        }

        public MeasureUnitProxy() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeUTF(this.type);
            out.writeUTF(this.subType);
            out.writeShort(0);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            this.type = in.readUTF();
            this.subType = in.readUTF();
            short extra = in.readShort();
            if (extra > 0) {
                byte[] extraBytes = new byte[extra];
                in.read(extraBytes, 0, extra);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return MeasureUnit.internalGetInstance(this.type, this.subType);
        }
    }

    @Deprecated
    protected static interface Factory {
        @Deprecated
        public MeasureUnit create(String var1, String var2);
    }
}

