/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailSender;
import com.urbancode.air.notification.email.EmailService;
import com.urbancode.air.notification.email.TemplatedEmailMessage;
import com.urbancode.air.notification.email.WrappedFileDataSource;
import com.urbancode.air.notification.template.TemplateApplication;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;

public class DirectTemplatedEmailSender
extends EmailSender {
    private static Logger logger = Logger.getLogger(DirectTemplatedEmailSender.class);
    private static final long serialVersionUID = -1929772359027636377L;

    public DirectTemplatedEmailSender(EmailService emailService) {
        super(emailService);
    }

    /*
     * Loose catch block
     */
    public void send(TemplatedEmailMessage email) throws NotificationException {
        block21: {
            Exception e22;
            WrappedFileDataSource bodySource;
            FileOutputStream fos;
            File tempFile;
            block19: {
                StringBuilder msg = this.buildRecipientLogMessage(email);
                logger.debug((Object)msg.toString());
                if (email.getToList().size() + email.getCcList().size() + email.getBccList().size() == 0) {
                    throw new NotificationException("No email addresses found for recipients");
                }
                tempFile = null;
                fos = null;
                bodySource = null;
                TemplateApplication subject = email.getSubject();
                String subjectLine = subject.getString();
                subjectLine = this.compressWhitespace(subjectLine).trim();
                InternetAddress[] toAddressArray = this.getInternetAddresses(email.getToList());
                InternetAddress[] ccAddressArray = this.getInternetAddresses(email.getCcList());
                InternetAddress[] bccAddressArray = this.getInternetAddresses(email.getBccList());
                TemplateApplication body = email.getBody();
                tempFile = File.createTempFile("email", "temp");
                tempFile.deleteOnExit();
                fos = new FileOutputStream(tempFile);
                body.writeTo(fos);
                fos.close();
                fos = null;
                bodySource = new WrappedFileDataSource(tempFile, body.getContentType(), body.getEncoding());
                DataHandler bodyHandler = new DataHandler((DataSource)bodySource);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(bodyHandler);
                ContentType contentType = new ContentType(bodySource.getContentType());
                bodyPart.setHeader("Content-Type", contentType.toString());
                String[] propNameArray = body.getPropertyNameArray();
                HashMap<String, String> headerProperties = new HashMap<String, String>();
                for (int i = 0; i < propNameArray.length; ++i) {
                    if (!propNameArray[i].trim().toUpperCase().startsWith("X-")) continue;
                    headerProperties.put(propNameArray[i], body.getProperty(propNameArray[i]).toString());
                }
                String primaryType = contentType.getPrimaryType();
                String encoding = contentType.getParameter("charset");
                String contentTransferEncoding = "text".equals(primaryType) && "US-ASCII".equalsIgnoreCase(encoding) ? "7bit" : "base64";
                bodyPart.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
                MimeBodyPart[] attachmentPartArray = new MimeBodyPart[]{};
                this.getEmailService().sendEmail(toAddressArray, ccAddressArray, bccAddressArray, subjectLine, bodyPart, attachmentPartArray, headerProperties);
                Object var22_25 = null;
                if (fos == null) break block19;
                try {
                    fos.close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (bodySource != null) {
                try {
                    bodySource.getInputStream().close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (tempFile != null && !tempFile.delete()) {
                logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
            }
            break block21;
            {
                catch (NotificationException e3) {
                    throw e3;
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Exception e5) {
                    logger.warn((Object)("Unable to send email: " + e5.getMessage()), (Throwable)e5);
                    throw new NotificationException(e5.getMessage(), e5);
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var22_26 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (bodySource != null) {
                    try {
                        bodySource.getInputStream().close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (tempFile != null && !tempFile.delete()) {
                    logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
                }
                throw throwable;
            }
        }
    }
}

