/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.twitter;

import com.urbancode.air.notification.twitter.TwitterMessage;
import com.urbancode.air.notification.twitter.TwitterSender;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterCollector
implements Runnable {
    private static final String READY_FILE_NAME = "_ready";
    private int pause = 10000;
    private Thread thread = new Thread((Runnable)this, "Twitter collector");
    private boolean running = true;
    private boolean sleeping = false;
    private File workingDir = null;
    private ExecutorService executor = null;
    private int maxSendingThreads = 0;
    private File readyFile = null;

    TwitterCollector(File workingDir, int maxSendingThreads) {
        this.workingDir = workingDir;
        this.maxSendingThreads = maxSendingThreads;
        this.executor = Executors.newFixedThreadPool(this.maxSendingThreads);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                System.out.println("Starting run()");
                this.sleeping = false;
                ArrayList<TwitterMessage> tempDirList = this.getSpooledTweets();
                System.out.println("Testing tempDir");
                System.out.println(tempDirList.isEmpty());
                if (!tempDirList.isEmpty()) {
                    for (TwitterMessage message : tempDirList) {
                        ArrayList<String> name = message.getRecipientList();
                        String body = message.getBody();
                        TwitterSender twitterSender = new TwitterSender(body, name);
                        this.executor.execute(twitterSender);
                    }
                }
                this.sleeping = true;
                System.out.println("Ending run()");
                Thread.sleep(this.pause);
            }
            catch (InterruptedException e) {
                System.out.println("InterruptedException");
                this.shutdown();
            }
        }
    }

    private ArrayList<TwitterMessage> getSpooledTweets() {
        ArrayList<File> tempDirList = new ArrayList<File>();
        this.readyFile = new File(this.workingDir, READY_FILE_NAME);
        FilenameFilter xmlFilter = new FilenameFilter(){
            private FileNameExtensionFilter filter = new FileNameExtensionFilter("XML file", "xml");

            public boolean accept(File dir, String str) {
                return this.filter.accept(new File(dir, str));
            }
        };
        File[] readyXML = this.readyFile.listFiles(xmlFilter);
        if (readyXML.length > 0) {
            for (File xml : readyXML) {
                tempDirList.add(xml);
            }
        }
        return this.parseTweetXML(tempDirList);
    }

    private ArrayList<TwitterMessage> parseTweetXML(ArrayList<File> fileList) {
        ArrayList<TwitterMessage> twitterList = new ArrayList<TwitterMessage>();
        DocumentBuilderFactory domFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
        DocumentBuilder domBuilder = null;
        System.out.println("0");
        try {
            domBuilder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        for (File xml : fileList) {
            TwitterMessage message = new TwitterMessage();
            try {
                Document dom = domBuilder.parse(xml.getAbsolutePath());
                Element root = dom.getDocumentElement();
                NodeList recipientNodes = root.getElementsByTagName("recipient");
                if (recipientNodes != null && recipientNodes.getLength() > 0) {
                    for (int i = 0; i < recipientNodes.getLength(); ++i) {
                        String recipient = recipientNodes.item(i).getTextContent();
                        message.addRecipient(recipient);
                    }
                }
                String body = root.getElementsByTagName("body").item(0).getTextContent();
                message.setBody(body);
                twitterList.add(message);
            }
            catch (SAXException se) {
                se.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            xml.delete();
        }
        return twitterList;
    }

    public void start() {
        if (this.thread == null || !this.thread.isAlive()) {
            System.out.println("Starting thread");
            this.thread = new Thread((Runnable)this, "Spooled twitter collector");
            this.thread.start();
        }
    }

    public void stop() {
        System.out.println("Stopping thread");
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    public void shutdown() {
        System.out.println("Shutting down thread");
        this.running = false;
        if (this.sleeping) {
            this.stop();
        } else {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.executor.shutdown();
        if (!this.executor.isTerminated()) {
            int shutdownWait = 60;
            try {
                this.executor.awaitTermination(shutdownWait, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
            }
        }
    }
}

