/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import com.urbancode.air.net.jms.ConnectionStrategy;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventService;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ConnectionStrategyJMSTopicEventService
extends EventService
implements MessageListener {
    private static final Logger log = Logger.getLogger(ConnectionStrategyJMSTopicEventService.class);
    private final ConnectionStrategy connectionStrategy;
    private final String consumerName;
    private final String topicName;
    private MessageProducer producer;
    private Destination producerDestination;
    private Session producerSession;
    private MessageConsumer consumer;
    private Topic consumerDestination;
    private Session consumerSession;

    public ConnectionStrategyJMSTopicEventService(ConnectionStrategy connectionStrategy, String consumerName, String topicName) {
        this.connectionStrategy = connectionStrategy;
        this.consumerName = consumerName;
        this.topicName = topicName;
    }

    public synchronized void start() throws Exception {
        Connection connection = this.connectionStrategy.getConnection();
        this.producerSession = connection.createSession(false, 1);
        this.producerDestination = this.producerSession.createTopic(this.topicName);
        this.producer = this.producerSession.createProducer(this.producerDestination);
        this.producer.setDeliveryMode(2);
        this.consumerSession = connection.createSession(false, 1);
        this.consumerDestination = this.consumerSession.createTopic(this.topicName);
        this.consumer = this.consumerSession.createDurableSubscriber(this.consumerDestination, this.consumerName);
        this.consumer.setMessageListener((MessageListener)this);
        super.start();
    }

    public synchronized void shutdown() {
        try {
            this.producer.close();
            this.consumer.close();
            this.consumerSession.close();
            this.producerSession.close();
        }
        catch (JMSException e) {
            log.error((Object)(this.getClass().getSimpleName() + " failed to close its session."), (Throwable)e);
        }
        super.shutdown();
    }

    public void onMessage(Message msg) {
        Event event = null;
        if (msg instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)msg;
            try {
                String jsonString = textMsg.getText();
                JSONObject jsonObject = new JSONObject(jsonString);
                event = new Event(jsonObject);
            }
            catch (JMSException e) {
                throw new RuntimeException("Could not get Event from TextMessage.");
            }
            catch (JSONException e) {
                throw new RuntimeException("Re-creating Event from JSON string");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received Event: " + event));
            }
        } else {
            throw new RuntimeException("Received unknown Message type (" + msg.getClass().getCanonicalName() + ") " + "in " + this.getClass().getSimpleName());
        }
        super.run(event);
    }

    public void sendEvent(Event event) {
        if (this.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending Event: " + event));
            }
            try {
                TextMessage message = this.producerSession.createTextMessage(event.getProperties().toString());
                this.producer.send((Message)message);
            }
            catch (JMSException e) {
                log.error((Object)("Error sending sending Event(" + event + "): "), (Throwable)e);
            }
        } else {
            log.error((Object)"Tried to send event before EventService has started.");
            throw new RuntimeException("Tried to send event before EventService has started.");
        }
    }
}

