/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.scripting;

import com.urbancode.commons.scripting.ScriptException;
import com.urbancode.commons.scripting.ScriptLanguage;
import com.urbancode.commons.scripting.ScriptSource;
import com.urbancode.commons.scripting.ScriptSourceImplString;
import java.io.Serializable;

public class ScriptMetaData
implements Serializable {
    private static final long serialVersionUID = 6038643876416837181L;
    private String name = null;
    private String scriptPath = null;
    private ScriptLanguage lang = null;
    private ScriptSource source = null;

    public ScriptMetaData() {
    }

    public ScriptMetaData(ScriptLanguage lang, String script) {
        this(null, null, lang, script);
    }

    public ScriptMetaData(String name, String path, ScriptLanguage lang, String script) {
        this(name, path, lang, new ScriptSourceImplString(script));
    }

    public ScriptMetaData(String name, String path, ScriptLanguage lang, ScriptSource source) {
        if (lang == null) {
            throw new IllegalArgumentException("ScriptLanguage can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("ScriptSource can't be null");
        }
        this.name = name;
        this.scriptPath = path;
        this.lang = lang;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public ScriptLanguage getLanguage() {
        return this.lang;
    }

    public void setLanguage(ScriptLanguage lang) {
        this.lang = lang;
    }

    public ScriptSource getScriptSource() {
        return this.source;
    }

    public void setSource(ScriptSource source) {
        this.source = source;
    }

    public String getScriptContent() throws ScriptException {
        return this.source.getScriptContent();
    }

    public String toString() {
        String result = this.getClass().getName() + " {";
        result = result + "\n  name:         " + String.valueOf(this.name);
        result = result + "\n  scriptPath:   " + String.valueOf(this.scriptPath);
        result = result + "\n  languageName: " + String.valueOf((Object)this.lang);
        result = result + "\n  scriptSource: " + String.valueOf(this.source);
        result = result + "\n}";
        return result;
    }
}

