/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.template;

import com.urbancode.air.notification.template.Template;
import com.urbancode.air.notification.template.TemplateSectionNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiSectionTemplate {
    static final Logger log = Logger.getLogger((String)MultiSectionTemplate.class.getName());
    private static final String BEGIN = "## BEGIN SECTION ";
    private static final String END = "## END SECTION ";
    private Template template;
    private Map<Template, TemplateSection> template2templateSection = new HashMap<Template, TemplateSection>();
    private Map<String, List<Template>> name2template = new HashMap<String, List<Template>>();

    protected static int endOfLine(String s, int start) {
        int r = s.indexOf("\r", start);
        int n = s.indexOf("\n", start);
        int result = r != -1 && r < n || n == -1 ? r : n;
        return result;
    }

    public MultiSectionTemplate(Template template) {
        if (template == null) {
            throw new NullPointerException("template parameter can't be null");
        }
        this.template = template;
        this.parseSections();
    }

    public Template[] getTemplateSectionArray() {
        Set<Template> keySet = this.template2templateSection.keySet();
        Template[] result = new Template[keySet.size()];
        keySet.toArray(result);
        return result;
    }

    public Template getTemplateSection() {
        Template result = null;
        Template[] templateArray = this.getTemplateSectionArray();
        if (templateArray.length > 0) {
            result = templateArray[0];
        }
        return result;
    }

    public Template[] getTemplateSectionArrayByName(String name) {
        Template[] result = new Template[]{};
        List<Template> templateList = this.name2template.get(name);
        if (templateList != null) {
            result = new Template[templateList.size()];
            templateList.toArray(result);
        }
        return result;
    }

    public Template getTemplateSectionByName(String name) throws TemplateSectionNotFoundException {
        Template result = null;
        Template[] templateArray = this.getTemplateSectionArrayByName(name);
        if (templateArray.length > 0) {
            result = templateArray[0];
        }
        if (result == null) {
            throw new TemplateSectionNotFoundException(name);
        }
        return result;
    }

    public String getProperty(Template template, String name) {
        String result = null;
        TemplateSection section = this.template2templateSection.get(template);
        if (section != null) {
            result = section.getProperty(name);
        }
        return result;
    }

    public String[] getPropertyNameArray(Template template) {
        String[] result = new String[]{};
        TemplateSection section = this.template2templateSection.get(template);
        if (section != null) {
            result = section.getPropertyNameArray();
        }
        return result;
    }

    private void parseSections() {
        String text = this.template.getTemplateText();
        int start = 0;
        int beginIndex = text.indexOf(BEGIN);
        if (beginIndex == -1) {
            ArrayList<Template> templateList = new ArrayList<Template>();
            TemplateSection monoSection = new TemplateSection(this.template);
            templateList.add(monoSection.getTemplate());
            this.template2templateSection.put(this.template, monoSection);
        } else {
            while ((beginIndex = text.indexOf(BEGIN, start)) != -1) {
                start = beginIndex + BEGIN.length();
                int eol = MultiSectionTemplate.endOfLine(text, start);
                if (eol == -1) {
                    eol = text.length();
                }
                beginIndex = eol;
                String sectionName = text.substring(start, eol).trim();
                log.debug((Object)("found section " + sectionName));
                start = eol + 1;
                int endIndex = text.indexOf(END, start);
                if (endIndex < beginIndex) {
                    throw new IllegalStateException("Did not find ## END SECTION  for section '" + sectionName + "' in template");
                }
                String sectionText = text.substring(beginIndex, endIndex);
                Template newTemplate = new Template();
                newTemplate.setName(sectionName);
                newTemplate.setTemplateLoader(this.template.getTemplateLoader());
                newTemplate.setContextScript(this.template.getContextScript());
                newTemplate.setTemplateText(sectionText + System.getProperty("line.separator"));
                TemplateSection section = new TemplateSection(newTemplate);
                this.template2templateSection.put(newTemplate, section);
                List<Template> templateList = this.name2template.get(sectionName);
                if (templateList == null) {
                    templateList = new ArrayList<Template>();
                    this.name2template.put(sectionName, templateList);
                }
                templateList.add(newTemplate);
                start = endIndex;
            }
        }
    }

    public int getTemplateCount() {
        return this.template2templateSection.size();
    }

    private static class TemplateSection {
        private static final String PROPERTY = "## PROPERTY ";
        private Template template;
        private Map<String, String> name2value = new HashMap<String, String>();

        public TemplateSection(Template template) {
            this.template = template;
            this.parseProperties();
            String contentType = this.getProperty("Content-Type");
            if (contentType != null) {
                template.setContentType(contentType);
            } else {
                template.setContentType("text/plain");
            }
        }

        public Template getTemplate() {
            return this.template;
        }

        public String getProperty(String name) {
            return this.name2value.get(name);
        }

        public void setProperty(String name, String value) {
            log.debug((Object)("Adding property to template: " + name + "  " + value));
            this.name2value.put(name, value);
        }

        public String[] getPropertyNameArray() {
            Set<String> keySet = this.name2value.keySet();
            String[] result = new String[keySet.size()];
            keySet.toArray(result);
            return result;
        }

        private void parseProperties() {
            String text = this.template.getTemplateText();
            int beginIndex = 0;
            int endIndex = this.template.getTemplateText().length();
            int start = 0;
            while ((start = text.indexOf(PROPERTY, start)) != -1) {
                int endOfPropertyMarker = start + PROPERTY.length();
                int eol = MultiSectionTemplate.endOfLine(text, endOfPropertyMarker);
                if (eol == -1) {
                    eol = text.length();
                }
                beginIndex = eol;
                String property = text.substring(endOfPropertyMarker, eol);
                int colonIndex = property.indexOf(":");
                if (colonIndex != -1) {
                    String name = property.substring(0, colonIndex).trim();
                    String value = property.substring(colonIndex + 1).trim();
                    this.setProperty(name, value);
                }
                start = eol;
            }
            this.template.setTemplateText(text.substring(beginIndex, endIndex).trim());
        }
    }
}

