/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailService {
    private static final Logger log = Logger.getLogger((String)EmailService.class.getName());
    private final String host;
    private final int port;
    private final String sender;
    private final String userName;
    private final String password;
    private final boolean useTls;
    private final EmailFilter emailFilter;
    private Session session = null;

    public EmailService(String host, int port, String sender, String userName, String password, boolean useTls) throws NotificationException {
        this(host, port, sender, userName, password, useTls, null);
    }

    public EmailService(String host, int port, String sender, String userName, String password, boolean useTls, EmailFilter emailFilter) throws NotificationException {
        try {
            new InternetAddress(host);
        }
        catch (AddressException e) {
            throw new NotificationException("Invalid host address", e);
        }
        try {
            new InternetAddress(sender);
        }
        catch (AddressException e) {
            throw new NotificationException("Invalid sender email address", e);
        }
        this.host = host;
        this.port = port;
        this.sender = sender;
        this.userName = userName;
        this.password = password;
        this.useTls = useTls;
        this.emailFilter = emailFilter != null ? emailFilter : new EmailFilter(){

            public Address[] filter(Address[] emails) {
                return emails;
            }

            public void configure(String paramName, String paramValue) {
            }
        };
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSender() {
        return this.sender;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public synchronized boolean sendEmail(File mimeMessageFile) throws NotificationException, IOException {
        boolean result = false;
        if (mimeMessageFile != null && mimeMessageFile.exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(mimeMessageFile);
            }
            catch (FileNotFoundException e) {
                throw new NotificationException("File containing mime message does not exist: " + mimeMessageFile.getAbsolutePath(), e);
            }
            try {
                log.debug((Object)("sendEmail() smtp.host: " + this.getHost()));
                log.debug((Object)("sendEmail() smtp.port: " + this.getPort()));
                log.debug((Object)("sendEmail() smtp.usetls: " + this.isUseTls()));
                log.debug((Object)("sendEmail() smtp.auth: " + (this.getUserName() != null && this.getPassword() != null)));
                Authenticator authenticator = null;
                if (this.getUserName() != null && this.getPassword() != null) {
                    authenticator = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            String username = EmailService.this.getUserName();
                            String password = EmailService.this.getPassword();
                            return new PasswordAuthentication(username, password);
                        }
                    };
                }
                if (this.session == null) {
                    Properties props = new Properties();
                    props.setProperty("mail.transport.protocol", "smtp");
                    props.setProperty("mail.smtp.host", this.getHost());
                    if (this.isUseTls()) {
                        props.setProperty("mail.smtp.starttls.enable", "true");
                    }
                    if (this.getUserName() != null && this.getUserName().trim().length() > 0) {
                        props.setProperty("mail.smtp.auth", "true");
                    }
                    props.setProperty("mail.smtp.port", String.valueOf(this.getPort()));
                    props.setProperty("mail.smtp.sendpartial", "true");
                    this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
                }
                MimeMessage message = new MimeMessage(this.session, (InputStream)inStream);
                inStream.close();
                result = this.filterRecipientsAndSend(message);
            }
            catch (SendFailedException e) {
                throw new NotificationException("Error sending email: " + e.getMessage(), e);
            }
            catch (MessagingException e) {
                throw new NotificationException("Error sending email: " + e.getMessage(), e);
            }
        }
        throw new NotificationException("File containing mime message does not exist: " + mimeMessageFile.getAbsolutePath());
        return result;
    }

    public synchronized boolean sendEmail(InternetAddress[] toRecipientArray, String subject, MimeBodyPart body) throws NotificationException {
        return this.sendEmail(toRecipientArray, null, null, subject, body, null, new HashMap<String, String>());
    }

    public synchronized boolean sendEmail(InternetAddress[] toRecipientArray, InternetAddress[] ccRecipientArray, InternetAddress[] bccRecipientArray, String subject, MimeBodyPart body, MimeBodyPart[] attachmentArray, Map<String, String> headerProperties) throws NotificationException {
        boolean result = false;
        try {
            boolean bccRecipientsExist;
            boolean toRecipientsExist = toRecipientArray != null && toRecipientArray.length > 0;
            boolean ccRecipientsExist = ccRecipientArray != null && ccRecipientArray.length > 0;
            boolean bl = bccRecipientsExist = bccRecipientArray != null && bccRecipientArray.length > 0;
            if (toRecipientsExist || ccRecipientsExist || bccRecipientsExist) {
                log.debug((Object)("sendEmail() smtp.host: " + this.getHost()));
                log.debug((Object)("sendEmail() smtp.port: " + this.getPort()));
                log.debug((Object)("sendEmail() smtp.usetls: " + this.isUseTls()));
                log.debug((Object)("sendEmail() smtp.auth: " + (this.getUserName() != null && this.getPassword() != null)));
                Authenticator authenticator = null;
                if (this.getUserName() != null && this.getPassword() != null) {
                    authenticator = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            String username = EmailService.this.getUserName();
                            String password = EmailService.this.getPassword();
                            return new PasswordAuthentication(username, password);
                        }
                    };
                }
                if (this.session == null) {
                    Properties props = new Properties();
                    props.setProperty("mail.transport.protocol", "smtp");
                    props.setProperty("mail.smtp.host", this.getHost());
                    if (this.isUseTls()) {
                        props.setProperty("mail.smtp.starttls.enable", "true");
                    }
                    if (this.getUserName() != null && this.getUserName().trim().length() > 0) {
                        props.setProperty("mail.smtp.auth", "true");
                    }
                    props.setProperty("mail.smtp.port", String.valueOf(this.getPort()));
                    props.setProperty("mail.smtp.sendpartial", "true");
                    this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
                }
                MimeMessage message = new MimeMessage(this.session);
                message.setFrom((Address)new InternetAddress(this.getSender()));
                log.debug((Object)("sendEmail() from: " + this.getSender()));
                if (toRecipientsExist) {
                    log.debug((Object)("sendEmail() to: " + Arrays.asList(toRecipientArray)));
                    message.addRecipients(Message.RecipientType.TO, (Address[])toRecipientArray);
                }
                if (ccRecipientsExist) {
                    log.debug((Object)("sendEmail() cc: " + Arrays.asList(ccRecipientArray)));
                    message.addRecipients(Message.RecipientType.CC, (Address[])ccRecipientArray);
                }
                if (bccRecipientsExist) {
                    log.debug((Object)("sendEmail() bcc: " + Arrays.asList(bccRecipientArray)));
                    message.addRecipients(Message.RecipientType.BCC, (Address[])bccRecipientArray);
                }
                message.setSubject(subject);
                message.setHeader("X-Mailer", "Anthill3");
                message.setSentDate(new Date());
                Set<Map.Entry<String, String>> entrySet = headerProperties.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    String propName = entry.getKey();
                    String propValue = entry.getValue();
                    message.setHeader(propName, propValue);
                }
                if (attachmentArray != null && attachmentArray.length > 0) {
                    MimeMultipart multipart = new MimeMultipart();
                    multipart.addBodyPart((BodyPart)body);
                    for (int i = 0; i < attachmentArray.length; ++i) {
                        MimeBodyPart part = attachmentArray[i];
                        part.setDisposition("attachment");
                        multipart.addBodyPart((BodyPart)part);
                    }
                    message.setContent((Multipart)multipart);
                } else {
                    message.setDataHandler(body.getDataHandler());
                    String contentType = body.getHeader("Content-Type", null);
                    String contentTransferEncoding = body.getHeader("Content-Transfer-Encoding", null);
                    message.setHeader("Content-Type", contentType);
                    message.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
                }
                result = this.filterRecipientsAndSend(message);
            } else {
                log.info((Object)"Email not sent. No recipients.");
            }
        }
        catch (SendFailedException sfe) {
            throw new NotificationException("Error sending email: " + sfe.getMessage(), sfe);
        }
        catch (MessagingException e) {
            throw new NotificationException("Error sending email: " + e.getMessage(), e);
        }
        return result;
    }

    private synchronized boolean filterRecipientsAndSend(MimeMessage message) throws MessagingException {
        boolean result = false;
        Address[] toRecipients = message.getRecipients(Message.RecipientType.TO);
        toRecipients = this.emailFilter.filter(toRecipients);
        Address[] ccRecipients = message.getRecipients(Message.RecipientType.CC);
        ccRecipients = this.emailFilter.filter(ccRecipients);
        Address[] bccRecipients = message.getRecipients(Message.RecipientType.BCC);
        bccRecipients = this.emailFilter.filter(bccRecipients);
        if (!(toRecipients != null && toRecipients.length != 0 || ccRecipients != null && ccRecipients.length != 0 || bccRecipients != null && bccRecipients.length != 0)) {
            log.debug((Object)("EmailFilter rejected all recipients for message " + message.getSubject()));
            log.debug((Object)"Original recipient list:");
            log.debug((Object)("\tTO: " + message.getRecipients(Message.RecipientType.TO)));
            log.debug((Object)("\tCC: " + message.getRecipients(Message.RecipientType.CC)));
            log.debug((Object)("\tBCC: " + message.getRecipients(Message.RecipientType.BCC)));
            result = false;
        } else {
            message.setRecipients(Message.RecipientType.TO, toRecipients);
            message.setRecipients(Message.RecipientType.CC, ccRecipients);
            message.setRecipients(Message.RecipientType.BCC, bccRecipients);
            message.setFrom((Address)new InternetAddress(this.getSender()));
            log.debug((Object)("sending email from '" + message.getSubject() + "' from " + this.getSender()));
            Transport.send((Message)message);
            result = true;
        }
        return result;
    }

    public String toString() {
        String s = "EmailService [";
        s = s + " host: " + this.getHost();
        s = s + " port: " + String.valueOf(this.getPort());
        s = s + " sender: " + this.getSender();
        s = s + " userName: " + this.getUserName();
        s = s + " password: " + this.getPassword();
        s = s + " use tls: " + String.valueOf(this.isUseTls());
        s = s + "]";
        return s;
    }
}

