/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email.spooler;

import com.urbancode.air.notification.EmailLock;
import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailService;
import com.urbancode.air.notification.email.spooler.ErrorHandler;
import com.urbancode.air.notification.email.spooler.RestoredEmail;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

class Emailer
implements Runnable {
    private static Logger logger = Logger.getLogger(Emailer.class);
    private File spooledEmailDir = null;
    private CountDownLatch latch;
    private EmailService emailService;
    private ErrorHandler errorHandler;
    private EmailLock emailLock;

    public Emailer(EmailService emailService, CountDownLatch latch, File spooledEmailDir, ErrorHandler errorHandler, EmailLock emailLock) throws NotificationException {
        this.emailService = emailService;
        this.spooledEmailDir = spooledEmailDir;
        this.latch = latch;
        this.errorHandler = errorHandler;
        this.emailLock = emailLock;
        if (spooledEmailDir == null) {
            throw new NotificationException("Error: Spooled email directory is null.");
        }
        if (!spooledEmailDir.exists()) {
            throw new NotificationException("Error: Spooled email directory doesn't exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            block7: {
                try {
                    RestoredEmail email = new RestoredEmail(this.spooledEmailDir);
                    String recipientsString = Arrays.toString(email.getToAddressArray());
                    logger.info((Object)("Sending email to " + recipientsString + "..."));
                    String emailFilename = email.getMessageFile().toString();
                    boolean locked = this.emailLock.acquireLock(emailFilename);
                    if (locked) {
                        boolean sent = this.emailService.sendEmail(email.getMessageFile());
                        if (sent) {
                            logger.info((Object)("Email to " + recipientsString + " sent"));
                        } else {
                            logger.info((Object)("Email to " + recipientsString + " not sent (probably all email addresses " + "were rejected by EmailFilter)"));
                        }
                        email.delete();
                        this.emailLock.releaseLock(emailFilename);
                        break block7;
                    }
                    logger.info((Object)"Another server is sending this email");
                }
                catch (Exception t) {
                    this.errorHandler.addError(t, this.spooledEmailDir);
                    Object var7_8 = null;
                    this.latch.countDown();
                }
            }
            Object var7_7 = null;
            this.latch.countDown();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.latch.countDown();
            throw throwable;
        }
    }
}

