/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.twitter;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.twitter.TwitterAccount;
import com.urbancode.air.notification.twitter.TwitterService;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class TwitterOAuthorizer {
    private static final long serialVersionUID = 531591236984892038L;
    private TwitterAccount account = null;
    private Token requestToken = null;
    private Verifier verifier = null;
    private String authorizationUrl = null;
    private Token accessToken = null;
    private OAuthService service = TwitterService.getService();

    public TwitterOAuthorizer(String accountName) {
        this.account = new TwitterAccount(accountName);
    }

    public String requestAuthorization() {
        this.requestToken = this.service.getRequestToken();
        this.authorizationUrl = this.service.getAuthorizationUrl(this.requestToken);
        return this.authorizationUrl;
    }

    public void verify(String verifier) throws NotificationException {
        this.verifier = new Verifier(verifier);
        try {
            this.accessToken = this.service.getAccessToken(this.requestToken, this.verifier);
        }
        catch (IllegalArgumentException e) {
            throw new NotificationException("Verification failed. Please make sure registration is complete.", e);
        }
        catch (OAuthException e) {
            throw new NotificationException("Verification failed. Please make sure the verification code is correct.", e);
        }
        this.account.setAccessToken(this.accessToken);
        this.register();
    }

    private void register() {
    }
}

