/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailServer {
    private static final long serialVersionUID = 317989802694566438L;
    private String host = null;
    private int port = 25;
    private String sender = null;
    private String userName = null;
    private String password = null;
    private boolean useTls = false;

    public MailServer(String host, int port, String sender, String userName, String password, boolean useTls) throws NotificationException {
        try {
            new InternetAddress(host);
        }
        catch (AddressException e) {
            throw new NotificationException("Invalid host address", e);
        }
        try {
            new InternetAddress(sender);
        }
        catch (AddressException e) {
            throw new NotificationException("Invalid sender email address", e);
        }
        this.host = host;
        this.port = port;
        this.sender = sender;
        this.userName = userName;
        this.password = password;
        this.useTls = useTls;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSender() {
        return this.sender;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public String toString() {
        String s = "MailServer [";
        s = s + " host: " + String.valueOf(this.host);
        s = s + " port: " + String.valueOf(this.port);
        s = s + " sender: " + String.valueOf(this.sender);
        s = s + " userName: " + String.valueOf(this.userName);
        s = s + " password: " + String.valueOf(this.password);
        s = s + " use tls: " + String.valueOf(this.useTls);
        s = s + "]";
        return s;
    }
}

