/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailService;
import com.urbancode.air.notification.email.TemplatedEmailMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplatedEmailSender {
    private static Logger logger = Logger.getLogger(TemplatedEmailSender.class);
    private EmailService emailService = null;

    public TemplatedEmailSender(EmailService emailService) {
        this.emailService = emailService;
        if (emailService == null) {
            throw new NullPointerException("EmailService can't be null");
        }
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public abstract void send(TemplatedEmailMessage var1) throws NotificationException;

    protected StringBuilder buildRecipientLogMessage(TemplatedEmailMessage email) {
        int i;
        StringBuilder msg = new StringBuilder("Medium Found ");
        msg.append(String.valueOf(email.getToList().size() + email.getCcList().size() + email.getBccList().size()));
        msg.append(" Email addresses:");
        if (email.getToList().size() > 0) {
            msg.append("To: [");
            for (i = 0; i < email.getToList().size(); ++i) {
                if (i > 0) {
                    msg.append(",");
                }
                msg.append(email.getToList().get(i));
            }
            msg.append("]\n");
        }
        if (email.getCcList().size() > 0) {
            msg.append("Cc: [");
            for (i = 0; i < email.getCcList().size(); ++i) {
                if (i > 0) {
                    msg.append(",");
                }
                msg.append(email.getCcList().get(i));
            }
            msg.append("]\n");
        }
        if (email.getBccList().size() > 0) {
            msg.append("Bcc: [");
            for (i = 0; i < email.getBccList().size(); ++i) {
                if (i > 0) {
                    msg.append(",");
                }
                msg.append(email.getBccList().get(i));
            }
            msg.append("]\n");
        }
        return msg;
    }

    protected String compressWhitespace(String s) {
        String token;
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(s);
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            result.append(token);
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            result.append(' ');
            result.append(token);
        }
        return result.toString();
    }

    protected InternetAddress[] getInternetAddresses(List<String> emailArray) {
        InternetAddress[] result = null;
        if (emailArray != null) {
            ArrayList<InternetAddress> emailList = new ArrayList<InternetAddress>();
            for (int i = 0; i < emailArray.size(); ++i) {
                try {
                    emailList.add(new InternetAddress(emailArray.get(i)));
                    continue;
                }
                catch (AddressException ae) {
                    logger.error((Object)("Error parsing e-mail address: " + ae.getMessage()));
                }
            }
            result = new InternetAddress[emailList.size()];
            result = emailList.toArray(result);
        }
        return result;
    }
}

