/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.template;

import com.urbancode.air.notification.template.MultiSectionTemplate;
import com.urbancode.air.notification.template.Template;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateLoader {
    private Map<String, MultiSectionTemplate> templateMap = new HashMap<String, MultiSectionTemplate>();
    private final String TEMPLATE_ELEMENT_NAME = "template";
    private final String NAME_ELEMENT_NAME = "name";
    private final String BODY_ELEMENT_NAME = "body";
    private final String DESCRIPTION_ELEMENT_NAME = "description";
    private final String CONTENT_TYPE_ELEMENT_NAME = "content-type";
    private File templateDir = null;

    public TemplateLoader(String templateDirString) throws JDOMException, IOException {
        File[] templateFiles;
        this.templateDir = new File(templateDirString);
        for (File templateFile : templateFiles = this.templateDir.listFiles(new XMLFileFilter())) {
            Document document = new SAXBuilder().build(templateFile);
            Element rootElement = document.getRootElement();
            if (!rootElement.getName().equals("template")) continue;
            Element templateNameElement = rootElement.getChild("name");
            Element templateBodyElement = rootElement.getChild("body");
            Element templateDescriptionElement = rootElement.getChild("description");
            Element templateContentTypeElement = rootElement.getChild("content-type");
            Template tempTemplate = new Template(templateNameElement.getText(), templateBodyElement.getText(), templateDescriptionElement.getText(), templateContentTypeElement.getText(), templateFile, null, this);
            MultiSectionTemplate multiTempTemplate = new MultiSectionTemplate(tempTemplate);
            this.templateMap.put(templateNameElement.getTextTrim(), multiTempTemplate);
        }
    }

    public TemplateLoader(List<Template> templates) {
        for (Template template : templates) {
            MultiSectionTemplate multiTempTemplate = new MultiSectionTemplate(template);
            this.templateMap.put(template.getName().trim(), multiTempTemplate);
        }
    }

    public void addTemplate(Template template) {
        MultiSectionTemplate multiTempTemplate = new MultiSectionTemplate(template);
        this.templateMap.put(template.getName(), multiTempTemplate);
    }

    public MultiSectionTemplate getMultiSectionTemplateByName(String templateName) {
        return this.templateMap.get(templateName);
    }

    public Set<String> getTemplateNames() {
        return this.templateMap.keySet();
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    class XMLFileFilter
    implements FileFilter {
        XMLFileFilter() {
        }

        public boolean accept(File file) {
            boolean result = false;
            if (file.getName().toLowerCase().endsWith("xml")) {
                result = true;
            }
            return result;
        }
    }
}

