/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Event;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.EventType;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.RelatedDeploymentExternalLink;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.TaskTag;
import java.io.IOException;

public class RelatedDeployment
extends ClientEntity<RelatedDeployment> {
    public ScheduledDeployment[] scheduledDeployments;
    public String statusState;
    public String statusText;
    public RelatedDeploymentExternalLink[] externalLinks;
    @JsonReadOnly
    public TaskTag[] taskTags;
    @JsonReadOnly
    public User creator;
    @JsonReadOnly
    public Event event;

    public RelatedDeployment() {
        this.path = "/relatedDeployments/";
    }

    public User getCreator() {
        return this.creator;
    }

    public Event getEvent() {
        return this.event;
    }

    public RelatedDeployment creator(User user) {
        this.creator = user;
        return this;
    }

    public ScheduledDeployment[] getScheduledDeployments() {
        return this.scheduledDeployments;
    }

    public RelatedDeployment setScheduledDeployments(ScheduledDeployment[] scheduledDeployments) {
        return this.scheduledDeployments(scheduledDeployments);
    }

    public void updateStatus(String statusColor, String statusText) {
        JsonObject json = new JsonObject();
        json.addProperty("statusState", statusColor);
        json.addProperty("statusText", statusText);
        RestAssured.given().body(json.toString()).put(this.path(this.id) + "/updateStatus", new Object[0]);
    }

    public void addScheduledDeployments(ScheduledDeployment ... sds) {
        JsonArray ids = new JsonArray();
        for (ScheduledDeployment sd : sds) {
            ids.add(new JsonPrimitive(sd.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).post(this.path(this.id) + "/scheduledDeployments", new Object[0]);
    }

    public void removeScheduledDeployment(ScheduledDeployment sd) {
        JsonArray ids = new JsonArray();
        String json = ids.toString();
        RestAssured.given().body(json).delete(this.path(this.id) + "/scheduledDeployment/" + sd.getId(), new Object[0]);
    }

    public RelatedDeployment scheduledDeployments(ScheduledDeployment ... scheduledDeployments) {
        this.handleNull(scheduledDeployments, "scheduledDeployments");
        this.scheduledDeployments = scheduledDeployments;
        return this;
    }

    public TaskTag[] getTaskTags() {
        return this.taskTags;
    }

    public RelatedDeployment taskTags(String ... tagIds) {
        RestAssured.given().body((Object)tagIds, ObjectMapperType.GSON).post(this.path(this.id) + "/taskTag", new Object[0]);
        return this;
    }

    public RelatedDeploymentExternalLink[] getExternalLinks() {
        this.externalLinks = ((Response)RestAssured.given().get(this.path(this.id) + "/externalLinks", new Object[0])).as(RelatedDeploymentExternalLink[].class, ObjectMapperType.GSON);
        return this.externalLinks;
    }

    public RelatedDeployment addExternalLink(String link, String name, String description) {
        RelatedDeploymentExternalLink externalLink = new RelatedDeploymentExternalLink();
        externalLink.link = link;
        externalLink.name = name;
        externalLink.description = description;
        RestAssured.given().body((Object)externalLink, ObjectMapperType.GSON).post(this.path(this.id) + "/externalLink/", new Object[0]);
        return this;
    }

    public RelatedDeployment updateExternalLink(String linkId, String link, String name, String description) {
        RelatedDeploymentExternalLink externalLink = new RelatedDeploymentExternalLink();
        externalLink.link = link;
        externalLink.name = name;
        externalLink.description = description;
        RestAssured.given().body((Object)externalLink, ObjectMapperType.GSON).post(this.path(this.id) + "/externalLink/" + linkId, new Object[0]);
        return this;
    }

    public RelatedDeployment deleteExternalLink(String linkId) {
        RestAssured.given().delete(this.path(this.id) + "/externalLink/" + linkId, new Object[0]);
        return this;
    }

    public RelatedDeploymentTimeRemaining getTimeRemaining() {
        return ((Response)RestAssured.given().get(this.path(this.id) + "/timeRemaining", new Object[0])).as(RelatedDeploymentTimeRemaining.class, ObjectMapperType.GSON);
    }

    public RelatedDeployment createForEvent(Event event) {
        JsonObject eventToTurn = new JsonObject();
        eventToTurn.addProperty("event", event.id);
        return ((Response)RestAssured.given().body(eventToTurn.toString()).post(this.path() + "createForEvent", new Object[0])).as(RelatedDeployment.class, ObjectMapperType.GSON);
    }

    public static RelatedDeploymentDataGenerator getDataGenerator() {
        return new RelatedDeploymentDataGenerator();
    }

    public static RelatedDeployment createdRelatedDeployment(String name) throws IOException, InterruptedException {
        RelatedDeployment result = RelatedDeployment.getDataGenerator().createRelatedDeployment(name + " type ", name);
        return result;
    }

    public class RelatedDeploymentTimeRemaining {
        public int completedCount;
        public Long endTimeOverride;
        public Long endTimePlanned;
        public Long estimatedEndTime;
        public Long estimatedStartTime;
        public int failedCount;
        public int notStartedCount;
        public int startedCount;
        public int totalCount;
    }

    public static class RelatedDeploymentDataGenerator
    extends ClientEntity.DataGenerator<RelatedDeployment> {
        public RelatedDeployment createRelatedDeployment(String eventTypeName, String eventName) {
            Long oneMonth = 2764800000L;
            EventType type = (EventType)((EventType)InternalClients.eventType().name(eventTypeName)).eventTypeModule("RelatedDeploymentModule").save();
            Event event = (Event)((Event)new Event().name(eventName)).type(type).setStartDate(System.currentTimeMillis()).endDate(System.currentTimeMillis() + oneMonth).save();
            event = (Event)event.get();
            RelatedDeployment result = event.getRelatedDeployment();
            return (RelatedDeployment)result.get();
        }
    }
}

