#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.ibm.icu.text.DateFormat
import com.urbancode.air.*
import com.urbancode.urelease.endpoint.framework.DeploymentReportsData;
import com.urbancode.release.rest.framework.Clients;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

// Compute relevant dates
DateFormat dateFormat = DateFormat.getDateInstance(DateFormat.SHORT)
DateFormat timeFormat = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT)

Calendar now = Calendar.getInstance()
println "Now: "+timeFormat.format(now.getTimeInMillis())

Calendar startMonth = now.clone()
startMonth.set(Calendar.DAY_OF_MONTH, 1)
midnight(startMonth)
println "Start Month: "+timeFormat.format(startMonth.getTimeInMillis())

//----------------------------------------------------------------------------------------------
// Helper method for setting a calendar's time values to midnight (all zeros)
def Calendar midnight(Calendar cal) {
    cal.with {
        set(Calendar.HOUR_OF_DAY, 0)
        set(Calendar.MINUTE, 0)
        set(Calendar.SECOND, 0)
        set(Calendar.MILLISECOND, 0)
    }
}

Clients.loginWithToken(props['releaseServerUrl'], props['releaseToken']);
DeploymentReportsData.createData(startMonth.getTimeInMillis())
println "Successfully created sample data!"