#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.ibm.icu.text.DateFormat
import com.urbancode.air.*
import com.urbancode.urelease.endpoint.framework.DeploymentReportsData;
import com.urbancode.release.rest.framework.Clients;
import java.net.URL;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def integrationId = props['releaseIntegrationProvider']
def releaseServerUrl = props['releaseServerUrl']

println "<p style='font-weight: bold;'>Run Reports Remotely</p>"

println "To run self-service reports remotely, you can trigger this report through a REST call with specific filters to specify the data in each report."

def url = new URL(new URL(releaseServerUrl), "integrationProvider/" + integrationId + "/RunRemotely")

println "<br>"

println "<p style='font-weight: bold;'>POST: </p>" 

println "<div style='margin-left: 25px; background-color: #eaeaea; padding: 15px;'>"
    
    println "<p>" + url.toString() + "</p>"

println "</div>"

println "<br><p style='font-weight: bold;'>Body (Json Object): <br><br></p>"

println "<div style='margin-left: 25px; background-color: #eaeaea; padding: 15px;'>"

def oneWeek = 7L * 24L * 60L * 60L * 1000L;

def endDate = System.currentTimeMillis() + (24L * 60L * 60L * 1000L)
def startDate = (System.currentTimeMillis() - oneWeek)

    println "{"
    println "<div style='margin-left: 25px;'>"
        println "&quot;recipients&quot;: &quot;admin1@mycompany.com,admin2@mycompany.com&quot;,"
        println "&quot;reportName&quot;: &quot;DeploymentSummaryReport&quot;,"
        println "&quot;startDate&quot;: " + startDate + ","
        println "&quot;endDate&quot;: " + endDate + ","
        println "&quot;releases&quot; : [&quot;Sample Release&quot;, &quot;July Release&quot;],"
        println "&quot;phases&quot; : [&quot;PROD&quot;],"
    println "</div>"
    println "}"

println "</div>"

println "<div style='margin-left: 25px;'>"
    println "<p><span style='font-weight: bold;'>recipients</span>: A comma separated string with email addresses to which a copy of the report will be sent</p>"
    println "<p><span style='font-weight: bold;'>reportName</span>: Available values are GlobalReleaseStatus, GlobalReleaseExecutiveSummary, ReleaseEventReadinessReport, DeploymentTrendReport, and DeploymentSummaryReport</p>"
    println "<p><span style='font-weight: bold;'>startDate</span>: Epoch millisecond timestamp to be a lower bound of Deployments' scheduled times</p>"
    println "<p><span style='font-weight: bold;'>endDate</span>: Epoch millisecond timestamp to be an upper bound of Deployments' scheduled times</p>"
    println "<p><span style='font-weight: bold;'>releases</span>: A json array of the names of releases to include in report</p>"
    println "<p><span style='font-weight: bold;'>phases</span>: A json array of the name of Phases to include in report (Default: [\"PROD\"]</p>"
println "</div>"

println "<p>All of the above parameters are optional.  If they are ommitted, the integration will use the default values set here.  The request will return when the report is generated and published.</p>"
// {
// 	"recipients": "adb84@case.edu",
// 	"releases" : ["Sample Release"],
// 	"reportName": "DeploymentSummaryReport"
// }