#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.ibm.icu.text.DateFormat
import com.urbancode.air.*
import com.urbancode.urelease.endpoint.framework.DeploymentReportsData;
import com.urbancode.release.rest.framework.Clients;
import java.net.URL;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def integrationId = props['releaseIntegrationProvider']
def releaseServerUrl = props['releaseServerUrl']

File inputPropsFile = new File(props['PLUGIN_INPUT_PROPS'])

def varDir =  inputPropsFile.getParentFile().getParentFile().getParentFile()

if (varDir.getName() == "var") {
    File reportDir = new File(varDir, "reports")

    if( !reportDir.exists() ) {
        reportDir.mkdirs()
    }


    for (File reportNameFolder : reportDir.listFiles()) {
        def files = []
        if (reportNameFolder.isDirectory()) {
            println "<p style='font-weight: bold;'>" + reportNameFolder.getName() +"</p>" 

            println "<div style='margin-left: 25px; background-color: #eaeaea; padding: 15px;'>"
            for (File reportFile : reportNameFolder.listFiles()) {
                files << reportFile.getName()
            }

            files = files.sort()

            files.each{ file -> 
                def url = new URL(new URL(releaseServerUrl), "reports/" + reportNameFolder.getName() + "/" + file)
                println "<a href='" + url + "'>" + file +  "</a>" 
            }
            println "</div>"

        }
    }
}