/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.Attachment;
import com.urbancode.air.notification.email.BasicEmailMessage;
import com.urbancode.air.notification.email.EmailSender;
import com.urbancode.air.notification.email.EmailService;
import com.urbancode.air.notification.email.WrappedFileDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;

public class BasicEmailSender
extends EmailSender {
    private static Logger logger = Logger.getLogger(BasicEmailSender.class);
    private static final long serialVersionUID = -1929772359027636378L;

    public BasicEmailSender(EmailService emailService) {
        super(emailService);
    }

    /*
     * Loose catch block
     */
    public void send(BasicEmailMessage email) throws NotificationException {
        block22: {
            Exception e22;
            WrappedFileDataSource bodySource;
            FileOutputStream fos;
            File tempFile;
            block20: {
                StringBuilder msg = this.buildRecipientLogMessage(email);
                logger.debug((Object)msg.toString());
                if (email.getToList().size() + email.getCcList().size() + email.getBccList().size() == 0) {
                    throw new NotificationException("No email addresses found for recipients");
                }
                tempFile = null;
                fos = null;
                bodySource = null;
                String subjectLine = email.getSubject();
                subjectLine = this.compressWhitespace(subjectLine).trim();
                InternetAddress[] toAddressArray = this.getInternetAddresses(email.getToList());
                InternetAddress[] ccAddressArray = this.getInternetAddresses(email.getCcList());
                InternetAddress[] bccAddressArray = this.getInternetAddresses(email.getBccList());
                String body = email.getBody();
                tempFile = File.createTempFile("email", "temp");
                tempFile.deleteOnExit();
                fos = new FileOutputStream(tempFile);
                fos.write(body.getBytes());
                fos.close();
                fos = null;
                bodySource = new WrappedFileDataSource(tempFile, "text/plain", "US-ASCII");
                DataHandler bodyHandler = new DataHandler((DataSource)bodySource);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(bodyHandler);
                ContentType contentType = new ContentType(bodySource.getContentType());
                bodyPart.setHeader("Content-Type", contentType.toString());
                String primaryType = contentType.getPrimaryType();
                String encoding = contentType.getParameter("charset");
                String contentTransferEncoding = "text".equals(primaryType) && "US-ASCII".equalsIgnoreCase(encoding) ? "7bit" : "base64";
                bodyPart.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
                ArrayList<MimeBodyPart> attachmentList = new ArrayList<MimeBodyPart>();
                for (Attachment attachment : email.getAttachmentList()) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    DataSource source = attachment.createDataSource();
                    messageBodyPart.setDataHandler(new DataHandler(source));
                    if (attachment.getContentType() != null) {
                        messageBodyPart.setHeader("Content-Type", attachment.getContentType());
                    }
                    messageBodyPart.setFileName(attachment.getFileName());
                    messageBodyPart.setDisposition("attachment");
                    attachmentList.add(messageBodyPart);
                }
                MimeBodyPart[] attachmentPartArray = new MimeBodyPart[attachmentList.size()];
                attachmentList.toArray(attachmentPartArray);
                this.getEmailService().sendEmail(toAddressArray, ccAddressArray, bccAddressArray, subjectLine, bodyPart, attachmentPartArray, new HashMap<String, String>());
                Object var23_25 = null;
                if (fos == null) break block20;
                try {
                    fos.close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (bodySource != null) {
                try {
                    bodySource.getInputStream().close();
                }
                catch (Exception e22) {
                    logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                }
            }
            if (tempFile != null && !tempFile.delete()) {
                logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
            }
            break block22;
            {
                catch (NotificationException e3) {
                    throw e3;
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Exception e5) {
                    logger.warn((Object)("Unable to send email: " + e5.getMessage()), (Throwable)e5);
                    throw new NotificationException(e5.getMessage(), e5);
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var23_26 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close output stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (bodySource != null) {
                    try {
                        bodySource.getInputStream().close();
                    }
                    catch (Exception e22) {
                        logger.warn((Object)("Unable to close input stream: " + e22.getMessage()), (Throwable)e22);
                    }
                }
                if (tempFile != null && !tempFile.delete()) {
                    logger.warn((Object)("Unable to delete temporary file '" + tempFile.getPath() + "'."));
                }
                throw throwable;
            }
        }
    }
}

