/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email.spooler;

import com.urbancode.air.notification.DefaultEmailLock;
import com.urbancode.air.notification.EmailLock;
import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailService;
import com.urbancode.air.notification.email.TemplatedEmailMessage;
import com.urbancode.air.notification.email.spooler.RestoredEmail;
import com.urbancode.air.notification.email.spooler.SpooledEmailCollector;
import com.urbancode.air.notification.email.spooler.SpoolingTemplatedEmailSender;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailSpoolManager {
    private static Logger logger = Logger.getLogger(EmailSpoolManager.class);
    public static final String MESSAGE_FILE_NAME = "message";
    public static final String READY_FILE_NAME = "_ready";
    public static final String ERROR_FILE_NAME = "_error";
    private File workingDir = null;
    private File failedEmailDir = null;
    private EmailService emailService = null;
    private SpooledEmailCollector collector = null;
    private int maxSendingThreads = 0;
    private SpoolingTemplatedEmailSender sender = null;

    public EmailSpoolManager(EmailService emailService, File workingDir, File failedEmailDir, int maxSendingThreads) throws NotificationException {
        this(emailService, workingDir, failedEmailDir, maxSendingThreads, DefaultEmailLock.getInstance());
    }

    public EmailSpoolManager(EmailService emailService, File workingDir, File failedEmailDir, int maxSendingThreads, EmailLock lock) throws NotificationException {
        this.emailService = emailService;
        if (emailService == null) {
            throw new NotificationException("EmailService is null.");
        }
        this.workingDir = workingDir;
        this.failedEmailDir = failedEmailDir;
        if (workingDir.equals(failedEmailDir)) {
            throw new NotificationException("Working dir and failed email dir cannot be the same.");
        }
        if (!workingDir.exists() && !workingDir.mkdirs()) {
            throw new NotificationException("Spool directory doesn't exist and couldn't be created.");
        }
        if (!failedEmailDir.exists() && !failedEmailDir.mkdirs()) {
            throw new NotificationException("Failed email directory doesn't exist and couldn't be created.");
        }
        this.maxSendingThreads = maxSendingThreads;
        this.collector = new SpooledEmailCollector(this, lock);
        this.sender = new SpoolingTemplatedEmailSender(this);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public File getFailedEmailDir() {
        return this.failedEmailDir;
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public int getMaxSendingThreads() {
        return this.maxSendingThreads;
    }

    public void startCollector() {
        this.collector.start();
    }

    public void shutdownCollector() {
        this.collector.shutdown();
    }

    public void stopCollector() {
        this.collector.stop();
    }

    public boolean isCollectorAlive() {
        return this.collector.isAlive();
    }

    public void send(TemplatedEmailMessage email) throws NotificationException {
        this.sender.send(email);
    }

    public List<RestoredEmail> getFailedEmails() throws IOException, MessagingException {
        File[] failedDirs;
        ArrayList<RestoredEmail> failedEmails = new ArrayList<RestoredEmail>();
        for (File failedDir : failedDirs = this.getFailedEmailDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("mail-");
            }
        })) {
            failedEmails.add(new RestoredEmail(failedDir));
        }
        return failedEmails;
    }
}

