/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.event;

import com.urbancode.air.notification.email.spooler.EmailSpoolManager;
import com.urbancode.air.notification.event.NotificationEventListener;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventListener;
import com.urbancode.air.services.event.EventService;
import com.urbancode.commons.util.Check;
import java.util.ArrayList;
import java.util.List;

public class NotificationService {
    private static NotificationService instance = new NotificationService();
    private EventService eventService;
    private EmailSpoolManager spoolManager;
    private List<NotificationEventListener> listeners = new ArrayList<NotificationEventListener>();

    public static NotificationService getInstance() {
        return instance;
    }

    public static NotificationService initialize(EventService eventService, EmailSpoolManager spoolManager) {
        instance.removeAllListeners();
        instance = new NotificationService(eventService, spoolManager);
        return instance;
    }

    public static NotificationService initializeDisabled() {
        instance.removeAllListeners();
        instance = new NotificationService();
        return instance;
    }

    private NotificationService() {
    }

    private void removeAllListeners() {
        if (this.eventService != null) {
            for (NotificationEventListener listener : this.listeners) {
                this.eventService.removeEventListener((EventListener)listener);
            }
        }
    }

    private NotificationService(EventService eventService, EmailSpoolManager spoolManager) {
        Check.nonNull((Object)eventService, (String)"event service");
        Check.nonNull((Object)spoolManager, (String)"spool manager");
        this.eventService = eventService;
        this.spoolManager = spoolManager;
    }

    public void registerEventListener(NotificationEventListener listener) {
        if (this.eventService == null) {
            throw new RuntimeException("Cannot add event listeners to an uninitialized notification service.");
        }
        this.listeners.add(listener);
        listener.setSpoolManager(this.spoolManager);
        this.eventService.registerEventListener((EventListener)listener);
    }

    public void sendEvent(Event event) {
        if (this.eventService != null) {
            this.eventService.sendEvent(event);
        }
    }
}

