/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.template;

import com.urbancode.commons.util.SynchronizedDateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TemplateHelper {
    private static final Logger log = Logger.getLogger((String)TemplateHelper.class.getName());

    public static TemplateHelper getInstance() {
        return new TemplateHelper();
    }

    public String formatDate(Date date) {
        return this.formatDate(date, "EEE, d MMM yyyy HH:mm:ss Z");
    }

    public String formatDate(Date date, String format) {
        String result = null;
        try {
            SynchronizedDateFormat formatter = SynchronizedDateFormat.getInstance((String)format);
            result = formatter.format(date);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public float duration(long time) {
        float result = 0.0f;
        if (time > 0L) {
            try {
                result = (float)time / 1000.0f;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public float duration(Date start, Date stop) {
        float result = 0.0f;
        try {
            if (start == null) {
                throw new NullPointerException("start is null");
            }
            if (stop == null) {
                stop = new Date();
            }
            long startTime = start.getTime();
            long stopTime = stop.getTime();
            result = (float)(stopTime - startTime) / 1000.0f;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String formatNumber(float number, String format) {
        String result = null;
        try {
            DecimalFormat formatter = new DecimalFormat(format);
            result = formatter.format(number);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String formatNumber(double number, String format) {
        String result = null;
        try {
            DecimalFormat formatter = new DecimalFormat(format);
            result = formatter.format(number);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String formatNumber(String number, String format) {
        String result = null;
        try {
            result = this.formatNumber(Float.parseFloat(number), format);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

