/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.notification.email;

import com.urbancode.air.notification.NotificationException;
import com.urbancode.air.notification.email.EmailMessage;
import com.urbancode.air.notification.template.MultiSectionTemplate;
import com.urbancode.air.notification.template.Template;
import com.urbancode.air.notification.template.TemplateApplication;
import com.urbancode.air.notification.template.TemplateSectionNotFoundException;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatedEmailMessage
extends EmailMessage {
    private static Logger logger = Logger.getLogger(TemplatedEmailMessage.class);
    private static final long serialVersionUID = -1929772359027636377L;
    private MultiSectionTemplate template = null;
    private Template subjectTemplate = null;
    private Template bodyTemplate = null;
    private TemplateApplication subject = null;
    private TemplateApplication body = null;

    public TemplatedEmailMessage(MultiSectionTemplate template, Map<String, Object> context) throws NotificationException {
        super(context);
        if (template == null) {
            throw new IllegalArgumentException("Template required for message.");
        }
        this.template = template;
        try {
            this.subjectTemplate = template.getTemplateSectionByName("Subject");
            this.bodyTemplate = template.getTemplateSectionByName("Body");
        }
        catch (TemplateSectionNotFoundException e) {
            throw new NotificationException(e);
        }
    }

    public TemplateApplication getSubject() throws NotificationException {
        if (this.subject == null) {
            if (this.subjectTemplate == null) {
                throw new NotificationException("The template text did not include a Subject section marked by '## BEGIN SECTION Subject' and '## END SECTION Subject'.  Please add this section to your email notification template text.");
            }
            this.subject = new TemplateApplication(this.subjectTemplate);
            if (this.context != null) {
                for (String propName : this.context.keySet()) {
                    this.subject.setProperty(propName, this.context.get(propName));
                }
            }
        }
        return this.subject;
    }

    public TemplateApplication getBody() throws NotificationException {
        if (this.body == null) {
            if (this.bodyTemplate == null) {
                throw new NotificationException("The template text did not include a Body section marked by '## BEGIN SECTION Body' and '## END SECTION Body'.  Please add this section to your email notification template text.");
            }
            this.body = new TemplateApplication(this.bodyTemplate);
            if (this.context != null) {
                for (String propName : this.context.keySet()) {
                    this.body.setProperty(propName, this.context.get(propName));
                }
            }
            String[] propertyNameArray = this.template.getPropertyNameArray(this.bodyTemplate);
            for (int i = 0; i < propertyNameArray.length; ++i) {
                String propName = propertyNameArray[i];
                this.body.setProperty(propName, this.template.getProperty(this.bodyTemplate, propName));
            }
        }
        return this.body;
    }
}

