/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;

public class PublicFieldUberspect
extends UberspectImpl {
    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        Class<?> clazz = obj.getClass();
        boolean isArray = clazz.isArray();
        boolean isLength = identifier.equals("length");
        if (isArray && isLength) {
            return new ArrayLengthGetter();
        }
        VelPropertyGet getter = super.getPropertyGet(obj, identifier, i);
        try {
            getter.getMethodName();
            return getter;
        }
        catch (NullPointerException notFound) {
            Field field = obj.getClass().getField(identifier);
            if (field != null) {
                return new PublicFieldGetter(field);
            }
            return null;
        }
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        VelPropertySet setter = super.getPropertySet(obj, identifier, arg, i);
        if (setter != null) {
            return setter;
        }
        Field field = obj.getClass().getField(identifier);
        if (field != null) {
            return new PublicFieldSetter(field);
        }
        return null;
    }

    protected class PublicFieldSetter
    implements VelPropertySet {
        private Field field = null;

        public PublicFieldSetter(Field field) {
            this.field = field;
        }

        public Object invoke(Object o, Object value) throws Exception {
            this.field.set(o, value);
            return null;
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return "public field setter";
        }
    }

    protected class ArrayLengthGetter
    implements VelPropertyGet {
        public Object invoke(Object o) throws Exception {
            return new Integer(Array.getLength(o));
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return "array length getter";
        }
    }

    protected class PublicFieldGetter
    implements VelPropertyGet {
        private Field field = null;

        public PublicFieldGetter(Field field) {
            this.field = field;
        }

        public Object invoke(Object o) throws Exception {
            return this.field.get(o);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return "public field getter";
        }
    }
}

