/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventService;
import com.urbancode.commons.util.concurrent.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AsynchronousEventService
extends EventService {
    private static final Logger log = Logger.getLogger(AsynchronousEventService.class);
    protected final ExecutorService executor;

    public AsynchronousEventService() {
        this(null);
    }

    public AsynchronousEventService(ExecutorService executor) {
        if (executor == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory("AsynEventService", NamedThreadFactory.ThreadMode.DAEMON);
            int nThreads = Integer.getInteger("com.urbancode.air.services.event.AsynchronousEventService.numThreads", 10);
            executor = Executors.newFixedThreadPool(nThreads, (ThreadFactory)threadFactory);
        }
        this.executor = executor;
    }

    public void sendEvent(Event event) {
        if (this.isShutdown()) {
            log.warn((Object)("Ignoring event: " + event + " (service shutdown)"));
            return;
        }
        if (event != null) {
            ProcessEventRunnable runnable = new ProcessEventRunnable(event);
            this.addRunnable(runnable);
        }
    }

    void addRunnable(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public synchronized void waitForShutdown() {
        try {
            super.waitForShutdown();
        }
        catch (Exception e) {
            log.warn((Object)"Error shutting down EventService: ", (Throwable)e);
        }
        log.info((Object)"Shutting thread pool down...");
        this.executor.shutdown();
        if (!this.executor.isTerminated()) {
            int shutdownWait = 60;
            long start = System.currentTimeMillis();
            log.info((Object)("Thread pool still active - awaiting shutdown for " + shutdownWait + " s..."));
            try {
                this.executor.awaitTermination(shutdownWait, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)"Stopping thread pool", (Throwable)e);
                log.info((Object)"Forcing thread pool shutdown");
                this.executor.shutdownNow();
            }
            long stop = System.currentTimeMillis();
            long time = (stop - start) / 1000L;
            log.info((Object)("Thread pool terminated after " + time + " s"));
        } else {
            log.info((Object)"Thread pool terminated immediately");
        }
    }

    public class ProcessEventRunnable
    implements Runnable {
        private Event event = null;

        public ProcessEventRunnable(Event event) {
            this.event = event;
        }

        public void run() {
            AsynchronousEventService.this.run(this.event);
        }
    }
}

