/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.scripting;

import bsh.Parser;
import com.urbancode.commons.scripting.BSFManagerHandle;
import com.urbancode.commons.scripting.ScriptException;
import com.urbancode.commons.scripting.ScriptLanguage;
import com.urbancode.commons.scripting.ScriptMetaData;
import groovy.lang.GroovyShell;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.CodeBuffer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEvaluator {
    private static final Logger log = Logger.getLogger((String)ScriptEvaluator.class.getName());
    private static ScriptEvaluator instance = new ScriptEvaluator();

    public static Object evaluate(String script, ScriptLanguage language) throws ScriptException {
        return ScriptEvaluator.evaluate(new ScriptMetaData(language, script), null, null, null);
    }

    public static Object evaluate(ScriptMetaData script, Map<String, ?> params, String[] addImports, BSFManagerHandle handle) throws ScriptException {
        return instance.doEvaluate(script, params, addImports, handle);
    }

    public static void parseScript(String script, ScriptLanguage language) throws ScriptException {
        ScriptEvaluator.parseScript(new ScriptMetaData(language, script), null);
    }

    public static void parseScript(ScriptMetaData script, String[] addImports) throws ScriptException {
        instance.doParseScript(script, addImports);
    }

    protected ScriptEvaluator() {
    }

    protected Object doEvaluate(ScriptMetaData script, Map<String, ?> params, String[] addImports, BSFManagerHandle handle) throws ScriptException {
        Object result = null;
        if (script == null) {
            throw new NullPointerException("ScriptMetaData can't be null");
        }
        BSFManager mgr = new BSFManager();
        if (handle != null) {
            handle.setManager(mgr);
        }
        try {
            if (params != null) {
                for (Map.Entry<String, ?> nvp : params.entrySet()) {
                    String name = nvp.getKey();
                    Object value = nvp.getValue();
                    Class<?> type = value == null ? null : value.getClass();
                    log.debug((Object)("Adding param: " + name));
                    mgr.declareBean(name, value, type);
                }
            }
            String runScript = this.addHelperImports(script.getScriptContent(), script.getLanguage(), addImports);
            log.debug((Object)("running " + (Object)((Object)script.getLanguage()) + " script: " + runScript));
            result = mgr.eval(script.getLanguage().getName(), "noFile", 0, 0, (Object)runScript);
        }
        catch (BSFException e) {
            if (e.getCause() != null) {
                throw new ScriptException(e.getMessage(), e.getCause());
            }
            throw new ScriptException(e.getMessage());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new ScriptException(e.getMessage(), e.getCause());
            }
            throw new ScriptException(e.getMessage());
        }
        return result;
    }

    protected void doParseScript(ScriptMetaData script, String[] addImports) throws ScriptException {
        try {
            if (ScriptLanguage.BEANSHELL.equals((Object)script.getLanguage())) {
                Parser parser = new Parser((Reader)new StringReader(script.getScriptContent()));
                while (!parser.Line()) {
                }
            } else if (ScriptLanguage.GROOVY.equals((Object)script.getLanguage())) {
                GroovyShell shell = new GroovyShell();
                shell.parse(script.getScriptContent());
            } else {
                BSFManager mgr = new BSFManager();
                String runScript = this.addHelperImports(script.getScriptContent(), script.getLanguage(), addImports);
                log.debug((Object)("running " + (Object)((Object)script.getLanguage()) + " script: " + runScript));
                mgr.compileScript(script.getLanguage().getName(), "noFile", 0, 0, (Object)runScript, new CodeBuffer());
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private String addHelperImports(String script, ScriptLanguage language, String[] packages) {
        StringBuilder s = new StringBuilder("");
        if (packages != null) {
            if (ScriptLanguage.BEANSHELL.equals((Object)language) || ScriptLanguage.GROOVY.equals((Object)language)) {
                for (String package1 : packages) {
                    s.append("import ").append(package1).append(".*;");
                }
            } else if (ScriptLanguage.JAVASCRIPT.equals((Object)language)) {
                for (String package1 : packages) {
                    s.append("importPackage(Packages.").append(package1).append(");");
                }
            }
        }
        s.append(script);
        return s.toString();
    }
}

