/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.urelease

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.text.SimpleDateFormat;

import org.apache.log4j.Logger;

import com.urbancode.release.rest.models.internal.RelatedDeployment;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.Release;

/**
 * Utilities to assist with email sending in tests and plugins.
 * @author pcentgraf
 */
public class UrlHelper {

    public static String concatPaths(String... paths) {

        String result = null

        for (String path : paths) {
            if(result != null && result.length() > 0 && result.charAt(result.length() - 1) == '/') {
                result = result.substring(0, result.length()-2)
            }

            if(path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1)
            }

            if(result == null) {
                result = path
            } else {
                result = result + "/" + path
            }
        }

        return result;
    }

}
