/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.urelease.plugin.rtc;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.urelease.plugin.rtc.OslcOAuthDefaultClient;
import com.urbancode.urelease.plugin.rtc.OslcXmlReader;
import com.urbancode.urelease.plugin.rtc.models.OslcItem;
import com.urbancode.urelease.plugin.rtc.models.OslcProjectArea;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.client.httpclient4.HttpClientPool;
import org.apache.http.client.HttpClient;
import org.apache.wink.client.ClientResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.lyo.client.oslc.resources.ChangeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcHelper {
    private static final QName OSLC_PLANNED_FOR = new QName("http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/", "plannedFor");
    private static final QName OSLC_FILE_AGAINST = new QName("http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/", "filedAgainst");
    private static final QName OSLC_SEVERITY = new QName("http://open-services.net/ns/cm-x#", "severity");
    private static final String NONE_VALUE = "NONE_VALUE";
    private static final String QUERY_URL = "/oslc/queries/";
    private static final int NB_RESULT_PER_PAGE = 20;
    private static final String QUERY_RESULTS = "/rtc_cm:results";
    private static HttpClient httpClient;
    private static OslcOAuthDefaultClient oAuthClient;
    private OslcProjectArea projectArea;
    private String projectAreaId;
    private String consumerKey;
    private String consumerSecret;
    private String webContextUrl;

    public OslcHelper(String oslcBaseUrl, String consumerKey, String consumerSecret, String projectArea) {
        this.webContextUrl = this.cleanServerUrl(oslcBaseUrl);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.oAuthentication();
        if (projectArea != null && !projectArea.equals(NONE_VALUE)) {
            this.projectArea = this.getProjectAreaById(projectArea);
        }
    }

    public void oAuthentication() {
        oAuthClient = null;
        try {
            this.setupSSL(httpClient);
            OAuthServiceProvider provider = new OAuthServiceProvider(this.getRequestUrl(this.webContextUrl), this.getAuthorizeUrl(this.webContextUrl), this.getAccessUrl(this.webContextUrl));
            OAuthConsumer consumer = new OAuthConsumer("/", this.consumerKey, this.consumerSecret, provider);
            new OAuthClient(new HttpClient4(new OauthHttpClientPool()));
            OAuthAccessor accessor = new OAuthAccessor(consumer);
            accessor.setProperty("oauth_accessor_secret", this.consumerSecret);
            accessor.tokenSecret = "";
            accessor.accessToken = "";
            accessor.requestToken = "";
            oAuthClient = new OslcOAuthDefaultClient(accessor, provider);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not create the OAuth Client " + e.getMessage());
            }
            throw new RuntimeException("Can not create the OAuth Client");
        }
    }

    private void setupSSL(HttpClient httpClient) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTrustAllCerts(true);
        httpClient = builder.buildClient();
    }

    private String getAccessUrl(String hostname) {
        return hostname + "/oauth-access-token";
    }

    private String getAuthorizeUrl(String hostname) {
        return hostname + "/oauth-authorize";
    }

    private String getRequestUrl(String hostname) {
        return hostname + "/oauth-request-token";
    }

    public String getQueryResults(String query2) throws Exception {
        String resultCode = "";
        ClientResponse response = oAuthClient.getResource(query2, "application/xml", "1.0");
        resultCode = "HTTPRESPONSE=>" + response.getStatusCode();
        return resultCode;
    }

    public List<String> getStatusesList() {
        ArrayList<String> list = new ArrayList();
        try {
            OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, this.projectArea);
            list = reader.getAllStatuses();
            Collections.sort(list);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not retrieve the Statuses list ", e);
            }
            throw new RuntimeException("Can not retrieve the Statuses list ", e);
        }
        return list;
    }

    public List<OslcItem> getTimelines() {
        OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, this.projectArea);
        ArrayList<OslcItem> list = new ArrayList<OslcItem>();
        OslcItem unassigned = new OslcItem("Unassigned", "Unassigned", "Unassigned", null, null);
        list.add(unassigned);
        try {
            String query2 = this.webContextUrl + "/oslc/iterations";
            list.addAll(reader.getItemList(reader.filterByProjectAreaAndTimeline(query2), "rtc_cm:Iteration"));
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not retrieve the Timeline list ", e);
            }
            throw new RuntimeException("Can not retrieve the Timeline list ", e);
        }
        return list;
    }

    public OslcProjectArea getProjectAreaById(String id) {
        OslcProjectArea project = null;
        try {
            OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, null);
            project = reader.getProjectAreaById(id);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not retrieve the Project Area by id " + e.getMessage(), e);
            }
            throw new RuntimeException("Can not retrieve the Project Area by id ", e);
        }
        return project;
    }

    public List<ChangeRequest> executeUpdateForQuery(String queryId, Date lastExecution, List<String> urlsExistingItem) {
        ArrayList<ChangeRequest> list = new ArrayList<ChangeRequest>();
        try {
            String queryUrl = this.webContextUrl + QUERY_URL + queryId + QUERY_RESULTS;
            OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, this.projectArea);
            List<Object> urlsItemToUpdate = new ArrayList();
            urlsItemToUpdate = reader.getItemToUpdate(queryUrl, urlsExistingItem, lastExecution);
            int nb = 0;
            for (String string : urlsItemToUpdate) {
                try {
                    ClientResponse response = null;
                    response = oAuthClient.getResource(string, "application/rdf+xml");
                    if (response == null) continue;
                    ChangeRequest cr = response.getEntity(ChangeRequest.class);
                    list.add(cr);
                    OslcHelper.printChangeRequestInfo(cr, ++nb);
                }
                catch (Exception ex) {
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not retrieve the Change Request list " + e.getMessage(), e);
            }
            throw new RuntimeException("Can not retrieve the Change Request list ", e);
        }
        return list;
    }

    public Map<String, String> getWorkItemToParentMap(String queryId) {
        String queryUrl = this.webContextUrl + QUERY_URL + queryId + QUERY_RESULTS;
        OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, this.projectArea);
        HashMap<String, String> workItemToParentIds = new HashMap<String, String>();
        try {
            JSONArray workItems = reader.getWorkItemHierarchyJson(queryUrl);
            for (int i = 0; i < workItems.length(); ++i) {
                JSONObject workItem = workItems.getJSONObject(i);
                JSONArray parents = workItem.getJSONArray("rtc_cm:com.ibm.team.workitem.linktype.parentworkitem.parent");
                String value = "";
                if (parents.length() == 1) {
                    value = parents.getJSONObject(0).getString("rdf:resource");
                }
                workItemToParentIds.put(workItem.getString("rdf:resource"), value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not retrieve the Change Request Hierarchy list " + e.getMessage(), e);
        }
        return workItemToParentIds;
    }

    private static void printChangeRequestInfo(ChangeRequest cr, int nb) {
        if (cr != null) {
            // empty if block
        }
    }

    public String getWebContextUrl() {
        return this.webContextUrl;
    }

    public void setWebContextUrl(String webContextUrl) {
        this.webContextUrl = webContextUrl;
    }

    public String getProjectAreaId() {
        return this.projectAreaId;
    }

    public void setProjectAreaId(String projectAreaId) {
        this.projectAreaId = projectAreaId;
    }

    private String cleanServerUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getUUIDFromURI(URI uri) {
        String value = null;
        if (uri != null && uri.getPath() != null) {
            value = uri.getPath();
            value = value.substring(value.lastIndexOf("/") + 1, value.length());
        }
        return value;
    }

    private URI getExtendedProperty(ChangeRequest changeRequest, QName key) {
        URI value = null;
        Map<QName, Object> map = changeRequest.getExtendedProperties();
        if (map.containsKey(key)) {
            value = (URI)map.get(key);
        }
        return value;
    }

    public URI getTimeLine(ChangeRequest changeRequest) {
        URI uri = null;
        uri = this.getExtendedProperty(changeRequest, OSLC_PLANNED_FOR);
        return uri;
    }

    public URI getSeverity(ChangeRequest changeRequest) {
        URI uri = null;
        uri = this.getExtendedProperty(changeRequest, OSLC_SEVERITY);
        return uri;
    }

    public URI getCategory(ChangeRequest changeRequest) {
        URI uri = null;
        uri = this.getExtendedProperty(changeRequest, OSLC_FILE_AGAINST);
        return uri;
    }

    private String getTypeFromWorkItem(ChangeRequest workItem) {
        String oslcType = "";
        if (workItem.getDctermsTypes() != null) {
            String[] arr$ = workItem.getDctermsTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String type;
                oslcType = type = arr$[i$];
            }
        }
        return oslcType;
    }

    private String findClosestInitiativeParent(ChangeRequest change, HashMap<String, String> hierarchy, ArrayList<String> initWorkIds) {
        String workItemId = change.getAbout().toString();
        while (!initWorkIds.contains(workItemId) && workItemId != "" && workItemId != null) {
            workItemId = hierarchy.get(workItemId);
        }
        return workItemId;
    }

    public List<OslcItem> getProjectAreas() {
        ArrayList<OslcItem> list = new ArrayList();
        try {
            OslcXmlReader reader = new OslcXmlReader(oAuthClient, this.webContextUrl, this.projectArea);
            String query2 = this.webContextUrl + "/oslc/projectareas";
            list = reader.getItemList(query2, "rtc_cm:Project");
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new RuntimeException("Can not retrieve the list of Project Area: " + e.getMessage(), e);
            }
            throw new RuntimeException("Can not retrieve the list of Project Area ", e);
        }
        return list;
    }

    private static class OauthHttpClientPool
    implements HttpClientPool {
        private OauthHttpClientPool() {
        }

        public HttpClient getHttpClient(URL arg0) {
            return httpClient;
        }
    }
}

