#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import com.urbancode.urelease.plugin.rtc.OslcHelper;

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def oslcUrl = props['oslcUrl']
def oslcKey = props['oslcKey']
def oslcSecret = props['oslcSecret']
def projectArea = props['projectArea']

def jsonArray = null;
def helper = new OslcHelper(oslcUrl, oslcKey, oslcSecret, projectArea)
def result = helper.getTimelines()

if (result != null) {
    if (result.size() > 0) {
    jsonArray = "[";
        result.each{
            key -> jsonArray +="{label:'"+key.title+"', value: '"+key.uri+"'},"
        }
    jsonArray += "]";
    }
}

println(jsonArray)