/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.calm.foundation.common.SecureDocumentBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderPool {
    private static DocumentBuilderPool fgDefaultDocumentBuilderPool;
    private static Object fgDefaultLock;
    private static int DEFAULT_MAX;
    private int max;
    private DocumentBuilderFactory factory;
    Stack<DocumentBuilder> pool;

    static {
        fgDefaultLock = new Object();
        DEFAULT_MAX = 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderPool getDefaultDocumentBuilderPool() {
        if (fgDefaultDocumentBuilderPool == null) {
            Object object = fgDefaultLock;
            synchronized (object) {
                if (fgDefaultDocumentBuilderPool == null) {
                    fgDefaultDocumentBuilderPool = new DocumentBuilderPool();
                }
            }
        }
        return fgDefaultDocumentBuilderPool;
    }

    public DocumentBuilderPool() {
        this(SecureDocumentBuilderFactory.newInstance());
    }

    public DocumentBuilderPool(DocumentBuilderFactory factory) {
        this(DEFAULT_MAX, factory);
    }

    public DocumentBuilderPool(int max, DocumentBuilderFactory factory) {
        this.max = max;
        this.factory = factory;
        this.pool = new Stack();
        this.pool.ensureCapacity(max);
    }

    public DocumentBuilderFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilder ret = null;
        Stack<DocumentBuilder> stack = this.pool;
        synchronized (stack) {
            if (!this.pool.empty()) {
                ret = this.pool.pop();
            }
        }
        if (ret == null) {
            ret = this.createNewDocumentBuilder();
        } else {
            ret.reset();
        }
        return ret;
    }

    protected DocumentBuilder createNewDocumentBuilder() throws ParserConfigurationException {
        return this.factory.newDocumentBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuilder(DocumentBuilder builder) {
        Stack<DocumentBuilder> stack = this.pool;
        synchronized (stack) {
            if (this.pool.size() < this.max) {
                this.pool.push(builder);
            }
        }
    }

    public Document parse(InputSource inputSource) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.parse(inputSource);
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public Document parse(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.parse(file);
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public Document parse(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public Document parse(String uri) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.parse(uri);
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public Document parse(InputStream inputStream, String systemId) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.parse(inputStream, systemId);
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }
}

