/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.model.IImageContentService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;

public class ResourceLocation {
    public static final String LOCAL_RESOURCE_SCHEME = "local";
    public static final String PLATFORM_RESOURCE_SCHEME = "platform";
    public static final String BUNDLE_RESOURCE_SCHEME = "bundleentry";
    public static final String PROCESS_ATTACHMENT_RESOURCE_SCHEME = "processattachment";
    public static final String HTTP_RESOURCE_SCHEME = "http";
    public static final String FILE_RESOURCE_SCHEME = "file";
    private static final String SLASH = "/";
    private static final String LOCALHOST_URL = "http://localhost/jazz/";
    private static String IMAGE_CONTENT_SERVICE_NAME = IImageContentService.class.getName();

    public static URI createRelativeProcessAttachmentURI(IProcessAttachment attachment) throws URISyntaxException {
        return ResourceLocation.createRelativeProcessAttachmentURI(attachment.getPath());
    }

    public static URI createRelativeProcessAttachmentURI(String path) throws URISyntaxException {
        return new URI(PROCESS_ATTACHMENT_RESOURCE_SCHEME, null, ResourceLocation.getAbsolutePath(path), null);
    }

    private static URI getAbsoluteProcessAttachmentURI(IProcessContainerHandle container, URI relativeUri) {
        URI result = null;
        try {
            result = new URI(PROCESS_ATTACHMENT_RESOURCE_SCHEME, null, ResourceLocation.getAbsolutePath(container, relativeUri.getPath()), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            Assert.isTrue((boolean)false);
        }
        return result;
    }

    public static URL getRemoteResourceURL(URI uri, String repositoryUrl) throws MalformedURLException {
        return ResourceLocation.getResourceURL(uri, repositoryUrl, true).toURL();
    }

    public static URL getResourceURL(URI uri, String repositoryUrl) throws MalformedURLException {
        return ResourceLocation.getResourceURL(uri, repositoryUrl, false).toURL();
    }

    public static URL getResourceURL(IProcessContainerHandle container, URI uri, String repositoryUrl) throws MalformedURLException {
        if (uri.getScheme() == null) {
            return null;
        }
        if (PROCESS_ATTACHMENT_RESOURCE_SCHEME.equals(uri.getScheme())) {
            uri = ResourceLocation.getAbsoluteProcessAttachmentURI(container, uri);
        }
        return ResourceLocation.getResourceURL(uri, repositoryUrl);
    }

    public static String getRemoteResourceURLPath(URI uri, String repositoryUrl) throws MalformedURLException, TeamRepositoryException {
        return ResourceLocation.getImageContentServicePath(ResourceLocation.getResourceURL(uri, repositoryUrl, true));
    }

    private static void assertAbsoluteProcessUri(URI uri) {
        String path = uri.getPath().substring(1);
        int index = path.indexOf(47);
        Assert.isLegal((index > 0 ? 1 : 0) != 0);
        String uuid = path.substring(0, index);
        UUID.valueOf((String)uuid);
    }

    private static URI getResourceURL(URI uri, String repositoryUrl, boolean remote) throws MalformedURLException {
        if (PLATFORM_RESOURCE_SCHEME.equals(uri.getScheme())) {
            return ResourceLocation.getPlatformURL(uri, repositoryUrl, remote);
        }
        if (PROCESS_ATTACHMENT_RESOURCE_SCHEME.equals(uri.getScheme())) {
            ResourceLocation.assertAbsoluteProcessUri(uri);
            return ResourceLocation.getProcessAttachmentURL(uri, repositoryUrl);
        }
        if (BUNDLE_RESOURCE_SCHEME.equals(uri.getScheme())) {
            return ResourceLocation.getBundleURL(uri, repositoryUrl, remote);
        }
        if (ResourceLocation.isRemoteProtocol(uri.getScheme())) {
            if (repositoryUrl != null && !uri.toString().startsWith(repositoryUrl)) {
                try {
                    Location location = Location.location((URI)uri);
                    Location retargeted = Location.location((Location)location, (String)repositoryUrl, null);
                    return retargeted.toAbsoluteUri();
                }
                catch (Exception exception) {}
            }
            return uri;
        }
        return ResourceLocation.createImageContentServiceURL(repositoryUrl, uri.getPath());
    }

    private static URI getProcessAttachmentURL(URI uri, String repositoryUrl) throws MalformedURLException {
        String path = ResourceLocation.createProcessAttachmentPath(uri);
        return ResourceLocation.createImageContentServiceURL(repositoryUrl, path);
    }

    private static URI getPlatformURL(URI uri, String repositoryUrl, boolean remote) throws MalformedURLException {
        if (remote || !ResourceLocation.existsLocally(uri)) {
            return ResourceLocation.createImageContentServiceURL(repositoryUrl, uri.getPath());
        }
        return uri;
    }

    private static URI getBundleURL(URI uri, String repositoryUrl, boolean remote) throws MalformedURLException {
        if (remote || !ResourceLocation.existsLocally(uri)) {
            return ResourceLocation.createImageContentServiceURL(repositoryUrl, ResourceLocation.createBundlePath(uri));
        }
        return uri;
    }

    private static URI createImageContentServiceURL(String repositoryUrl, String path) throws MalformedURLException {
        String repoUri = repositoryUrl == null ? null : ResourceLocation.getHttpRepositoryUrl(repositoryUrl);
        return Location.serviceLocation((String)repoUri, IImageContentService.class, (String)path, null).toAbsoluteUri();
    }

    private static String getHttpRepositoryUrl(String repositoryUrl) {
        if (repositoryUrl != null && repositoryUrl.startsWith("local:/")) {
            return LOCALHOST_URL;
        }
        return repositoryUrl;
    }

    public static boolean isRemoteProtocol(String protocol) {
        return protocol != null && protocol.startsWith(HTTP_RESOURCE_SCHEME);
    }

    private static boolean existsLocally(URI uri) {
        try {
            uri.toURL().openConnection();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private static String getAbsolutePath(String path) {
        if (!path.startsWith(SLASH)) {
            return SLASH + path;
        }
        return path;
    }

    private static String getAbsolutePath(IProcessContainerHandle container, String path) {
        return SLASH + container.getItemId().getUuidValue() + ResourceLocation.getAbsolutePath(path);
    }

    private static String createProcessAttachmentPath(URI uri) {
        String path = uri.getPath();
        StringBuffer buffer = new StringBuffer();
        buffer.append('/');
        buffer.append(PROCESS_ATTACHMENT_RESOURCE_SCHEME);
        if (!path.startsWith(SLASH)) {
            buffer.append('/');
        }
        buffer.append(path);
        return buffer.toString();
    }

    private static String createBundlePath(URI uri) {
        String path = uri.getPath();
        StringBuffer buffer = new StringBuffer();
        buffer.append('/');
        buffer.append(BUNDLE_RESOURCE_SCHEME);
        buffer.append('/');
        buffer.append(uri.getHost());
        if (!path.startsWith(SLASH)) {
            buffer.append('/');
        }
        buffer.append(path);
        return buffer.toString();
    }

    public static boolean isImageContentServiceURL(URL url) {
        return url.getPath().contains(IMAGE_CONTENT_SERVICE_NAME);
    }

    public static String getImageContentServicePath(URI uri) throws TeamRepositoryException {
        Location location = Location.location((URI)uri);
        return location.toRelativeUri().getRawPath();
    }
}

