/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import org.eclipse.core.runtime.IProgressMonitor;

public class CustomDefaultIterationProvider
implements IDefaultValueProvider<IIteration> {
    @Override
    public IIteration getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IIteration iteration;
        IConfiguration value = configuration.getChild("value");
        if (value == null) {
            return null;
        }
        String path = value.getString("content");
        if (path == null || "".equals(path.trim())) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultIterationProvider.PROVIDER_CONFIGURED_NO_VALUE"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultIterationProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((iteration = IterationsHelper.resolveIterationFromPath((IProcessAreaHandle)attribute.getProjectArea(), path, workItemCommon.getAuditableCommon(), monitor)) == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultIterationProvider.ITERATION_NOT_FOUND"), (Object)path, (Object[])new Object[]{workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultIterationProvider.NONE_WORK_ITEM"), attribute.getDisplayName()}));
        }
        if (!iteration.hasDeliverable()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultIterationProvider.ITERATION_NOT_ISHASDELIVERABLE"), (Object)iteration.getLabel(), (Object[])new Object[]{path, workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultIterationProvider.NONE_WORK_ITEM"), attribute.getDisplayName()}));
        }
        return iteration;
    }
}

